/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import net.morilib.unix.misc.WideCharSequence;
import net.morilib.unix.misc.WideString;

public final class WideStringBuilder
implements WideCharSequence {
    private static final int INIT_CAPACITY = 16;
    private int[] buf;
    private int len;

    public WideStringBuilder(int capacity) {
        this.buf = new int[capacity];
        this.len = 0;
    }

    public WideStringBuilder() {
        this(16);
    }

    private void chkind(int index) {
        if (index < 0 || index >= this.len) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    @Override
    public int charAt(int index) {
        this.chkind(index);
        return this.buf[index];
    }

    @Override
    public int length() {
        return this.len;
    }

    private void chkrange(int start, int end) {
        if (start < 0 || start >= this.len) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        if (end < 0 || end > this.len) {
            throw new IndexOutOfBoundsException(String.valueOf(end));
        }
        if (end < start) {
            throw new IndexOutOfBoundsException(String.valueOf(end));
        }
    }

    @Override
    public WideCharSequence subSequence(int start, int end) {
        this.chkrange(start, end);
        return new WideString(this.buf, start, end - start);
    }

    public void ensureCapacity(int l) {
        if (this.len + l >= this.buf.length) {
            int[] b2 = this.buf;
            this.buf = new int[b2.length * 2];
            System.arraycopy(b2, 0, this.buf, 0, this.len);
        }
    }

    public WideStringBuilder append(int c) {
        this.ensureCapacity(1);
        this.buf[this.len++] = c;
        return this;
    }

    public WideStringBuilder append(char c) {
        return this.append((int)c);
    }

    public WideStringBuilder append(WideString s) {
        this.ensureCapacity(s.length());
        System.arraycopy(s.wchars, 0, this.buf, this.len, s.length());
        this.len += s.length();
        return this;
    }

    public WideStringBuilder append(WideStringBuilder s) {
        this.ensureCapacity(s.length());
        System.arraycopy(s.buf, 0, this.buf, this.len, s.len);
        this.len += s.len;
        return this;
    }

    public WideStringBuilder append(String s) {
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            this.append(c);
            i += c > 65535 ? 2 : 1;
        }
        return this;
    }

    public WideStringBuilder delete(int start, int end) {
        this.chkrange(start, end);
        System.arraycopy(this.buf, end, this.buf, start, this.len - end);
        this.len -= end - start;
        return this;
    }

    public WideStringBuilder deleteCharAt(int index) {
        this.chkind(index);
        this.delete(index, index + 1);
        return this;
    }

    public WideString toWideString() {
        return new WideString(this.buf, 0, this.len);
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.len);
    }
}

