/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import net.morilib.sh.misc.XtraceStream;

public class ShTreeOr implements ShTree {

	private List<ShTree> line;

	public ShTreeOr(List<ShTree> line) {
		this.line = new ArrayList<ShTree>(line);
	}

	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream in,
			PrintStream out,
			PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		int a = 1;

		for(ShTree t : line) {
			if((a = t.eval(
					env, fs, cmds, run, in, out, err, p)) == 0) {
				return a;
			}
		}
		return a;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object l2 = new Object();

		for(int i = 0; i < line.size(); i++) {
			line.get(i).compileInternally(b, brk, cnt);
			b.addJmpNZ(l2);
		}
		b.addLabel(l2);
	}

	public String toString() {
		StringBuffer b = new StringBuffer();
		String d = "";

		for(ShTree l : line) {
			b.append(d).append(l);
			d = " || ";
		}
		return b.toString();
	}

}
