/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.misc;

import net.morilib.automata.lr.Terminal;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/12
 */
public class ConstantTerminal implements Terminal {

	/**
	 * 
	 */
	public static final ConstantTerminal ERROR =
			new ConstantTerminal("");

	//
	private String constant;

	/**
	 * 
	 * @param t
	 */
	public ConstantTerminal(String t) {
		constant = t;
	}

	/**
	 * 
	 */
	public String getConstant() {
		return constant;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return constant.hashCode();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		return (o instanceof ConstantTerminal &&
				constant.equals(((ConstantTerminal)o).constant));
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "<" + constant + ">";
	}

}
