/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.cmd;

import java.util.ResourceBundle;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/16
 */
public class DecultureOptions {

	//
	private static final String CLSNAME;
	private static ResourceBundle msgs;

	//
	String outputFilename, filename;

	//
	static {
		String p;

		p = DecultureOptions.class.getPackage().getName();
		CLSNAME = p.replace('.', '/');
		msgs = ResourceBundle.getBundle(CLSNAME + "/messages");
	}

	/**
	 * 
	 * @param p
	 * @return
	 */
	public String get(String p) {
		return msgs.getString(p);
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void print(String p, Object... a) {
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void perror(String p, Object... a) {
		System.out.print(msgs.getString("errorheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void pwarn(String p, Object... a) {
		System.out.print(msgs.getString("warnheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void pmessage(String p) {
		System.out.print(msgs.getString("errorheader"));
		System.out.println(p);
	}

	/**
	 * 
	 */
	public void usage() {
		int l = Integer.parseInt(msgs.getString("usage.length"));
		String x;

		print("title", Deculture.VERSION);
		for(int i = 1; i <= l; i++) {
			x = String.format("%03d", i);
			print("usage." + x);
		}
	}

	/**
	 * @return
	 */
	public String getOutputFilename() {
		return outputFilename;
	}

	/**
	 * @return
	 */
	public String getFilename() {
		return filename;
	}

}
