/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.cmd;

import java.util.ResourceBundle;

public class DecultureOptions {
    private static final String CLSNAME;
    private static ResourceBundle msgs;
    String outputFilename;
    String filename;

    static {
        String p = DecultureOptions.class.getPackage().getName();
        CLSNAME = p.replace('.', '/');
        msgs = ResourceBundle.getBundle(String.valueOf(CLSNAME) + "/messages");
    }

    public String get(String p) {
        return msgs.getString(p);
    }

    public void print(String p, Object ... a) {
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    public void perror(String p, Object ... a) {
        System.out.print(msgs.getString("errorheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    public void pwarn(String p, Object ... a) {
        System.out.print(msgs.getString("warnheader"));
        System.out.format(msgs.getString(p), a);
        System.out.println();
    }

    public void pmessage(String p) {
        System.out.print(msgs.getString("errorheader"));
        System.out.println(p);
    }

    public void usage() {
        int l = Integer.parseInt(msgs.getString("usage.length"));
        this.print("title", "0.0.1");
        int i = 1;
        while (i <= l) {
            String x = String.format("%03d", i);
            this.print("usage." + x, new Object[0]);
            ++i;
        }
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public String getFilename() {
        return this.filename;
    }
}

