/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.sh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.DefaultShVirtualDirectory;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShStat;

public class DecultureFileSystem
extends AbstractShFileSystem {
    private DefaultShVirtualDirectory root = new DefaultShVirtualDirectory(null, null);
    private ShFile fragmentFile;
    private ShFile definitionFile;

    public DecultureFileSystem(String d, String in) {
        this.fragmentFile = new StF("fragment", in);
        this.root.addFile(this.fragmentFile);
        this.definitionFile = new StF("definition", d);
        this.root.addFile(this.definitionFile);
    }

    @Override
    public ShFile getRoot() {
        return this.root;
    }

    @Override
    public ShFile getFile(String s) {
        if (s.equals("/")) {
            return this.root;
        }
        if (s.equals("fragment")) {
            return this.fragmentFile;
        }
        if (s.equals("definition")) {
            return this.definitionFile;
        }
        return null;
    }

    @Override
    public ShFile getFile(String dir, String name) {
        return this.getFile(this.getFile(dir), name);
    }

    @Override
    public ShFile getFile(ShFile dir, String name) {
        return null;
    }

    @Override
    public ShFile getNativeFile(String s) {
        return this.getFile(s);
    }

    @Override
    public ShSecurityPolicy getSecurityPolicy() {
        return ShSecurityPolicy.ALL_PERMITTED;
    }

    @Override
    public InputStream getProfile() {
        return null;
    }

    @Override
    public InputStream getRc() {
        return null;
    }

    @Override
    public ShFile getHome() {
        return this.getRoot();
    }

    @Override
    public ShFile searchPath(ShEnvironment env, String name) {
        return null;
    }

    private static class StF
    implements ShFile {
        private byte[] buf;
        private String name;

        StF(String name, String f) {
            this.name = name;
            this.buf = f.getBytes();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return this.buf.length == 0;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<ShFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buf);
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            return null;
        }

        @Override
        public ShProcess getProcess() {
            return null;
        }

        @Override
        public ShFile toAbsolute() {
            return this;
        }

        @Override
        public ShFile toCanonical() {
            return this;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return new ShStat(this.toString(), 0L, this.buf.length, 1);
        }

        public String toString() {
            return this.name;
        }
    }
}

