/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LRAction;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantTerminal;
import net.morilib.deculture.misc.DecultureException;
import net.morilib.deculture.sh.DecultureBuiltInCommands;
import net.morilib.deculture.translate.AbstractDecultureTranslator;
import net.morilib.deculture.translate.ActionConverter;
import net.morilib.deculture.translate.LRObject;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class DecultureTranslatorJava
extends AbstractDecultureTranslator {
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");
    private static final String RESOURCE = "/net/morilib/deculture/translate/y.tab.java.sh";

    DecultureTranslatorJava(LRObject lr) {
        super(lr);
    }

    private void _put(Puts p, int st, GrammarSymbol g, String f, PrintStream out) {
        if (g instanceof CharacterTerminal) {
            int c = ((CharacterTerminal)g).getCharacter();
            if (c >= 32 && c < 127) {
                out.printf("\t\t\t\t%sif(__eq(__t, '%c')) {\n", f, Character.valueOf((char)c));
            } else if (c == 10) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\n')) {\n", f);
            } else if (c == 13) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\r')) {\n", f);
            } else if (c == 9) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\t')) {\n", f);
            } else if (c == 12) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\f')) {\n", f);
            } else if (c == 8) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\b')) {\n", f);
            } else if (c == 92) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\\\')) {\n", f);
            } else if (c == 39) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\'')) {\n", f);
            } else if (c == 34) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\\"')) {\n", f);
            } else {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\u%04x')) {\n", f, c);
            }
            p.put(out, f, st, g);
        } else if (g instanceof ConstantTerminal) {
            String a = ((ConstantTerminal)g).getConstant();
            String x = this.lr.getDefinition().getType(a);
            if (a.equals("")) {
                out.printf("\t\t\t\t%sif(__eq(__t, __ERROR)) {\n", f);
            } else if (E_CONST.matcher(x).matches()) {
                out.printf("\t\t\t\t%sif(__eq(__t, %s)) {\n", f, x);
            } else {
                out.printf("\t\t\t\t%sif(__t instanceof %s) {\n", f, x);
            }
            p.put(out, f, st, g);
        } else if (g == ContextFreeGrammar.ENDMARKER) {
            out.printf("\t\t\t\t%sif(__end(__t)) {\n", f);
            p.put(out, f, st, g);
        } else {
            throw new DecultureException(g.toString());
        }
    }

    @Override
    protected String getResourceName() {
        return RESOURCE;
    }

    @Override
    public ShBuiltInCommands getCommands() {
        DecultureBuiltInCommands c = new DecultureBuiltInCommands();
        c.putCommand("put_shift", new PutShift());
        c.putCommand("put_reduce", new PutReduce());
        c.putCommand("put_accept", new PutAccept());
        c.putCommand("put_goto", new PutGoto());
        c.putCommand("put_states", new PutStates());
        return c;
    }

    @Override
    public String getExtension() {
        return ".java";
    }

    private class PutAccept
    extends Puts {
        private PutAccept() {
        }

        @Override
        boolean isput(int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            return a.isAccept();
        }

        @Override
        void put(PrintStream out, String f, int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            if (a.isAccept()) {
                out.printf("\t\t\t\t\treturn true;\n", new Object[0]);
            }
        }

        @Override
        void start(PrintStream out, int st, GrammarSymbol g) {
        }

        @Override
        String end() {
            return "return false;";
        }
    }

    private class PutGoto
    implements ShProcess {
        private PutGoto() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream out, PrintStream stderr, String ... args) throws IOException {
            int k = Integer.parseInt(args[1]);
            Set<Map.Entry<Nonterminal, Integer>> s = DecultureTranslatorJava.this.lr.getTable().goTos(k).entrySet();
            String f = "";
            for (Map.Entry<Nonterminal, Integer> e : s) {
                int n = DecultureTranslatorJava.this.getNonterminalNumber(e.getKey());
                out.printf("\t\t\t\t%sif(__n == %d) {\n", f, n);
                out.printf("\t\t\t\t\treturn %d;\n", e.getValue());
                f = "} else ";
            }
            if (!f.equals("")) {
                out.printf("\t\t\t\t}\n", new Object[0]);
            }
            out.printf("\t\t\t\tthrow new RuntimeException();\n", new Object[0]);
            return 0;
        }
    }

    private class PutReduce
    extends Puts {
        private PutReduce() {
        }

        @Override
        boolean isput(int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            return a.isReduce();
        }

        @Override
        void put(PrintStream out, String f, int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            if (!a.isReduce()) {
                return;
            }
            ContextFreeRule r = a.getReduceRule();
            int l = r.getDerivedSymbolLength();
            out.printf("\t\t\t\t\t_pop(%d);\n", l);
            out.printf("\t\t\t\t\t__k = _refsyn();\n", new Object[0]);
            out.printf("\t\t\t\t\t__k = getGoto(__k, %d);\n", DecultureTranslatorJava.this.getNonterminalNumber(r.getLeftSymbol()));
            out.printf("\t\t\t\t\t_push(__k, $$);\n", new Object[0]);
            out.printf("\t\t\t\t\treturn __k;\n", new Object[0]);
        }

        @Override
        void start(PrintStream out, int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            if (!a.isReduce()) {
                return;
            }
            ContextFreeRule r = a.getReduceRule();
            int l = r.getDerivedSymbolLength();
            Object o = DecultureTranslatorJava.this.actionMap.get(a.getReduceRule());
            if (o != null) {
                out.printf("\t\t\t\t\t$$ = null;\n", l);
                String s = ActionConverter.translate(r, DecultureTranslatorJava.this.lr.getDefinition(), o.toString());
                out.printf("\t\t\t\t\t%s\n", s);
            } else if (l > 0) {
                String s = ActionConverter.translate(r, DecultureTranslatorJava.this.lr.getDefinition(), "$$ = $1;");
                out.printf("\t\t\t\t\t%s\n", s);
            } else {
                out.printf("\t\t\t\t\t$$ = null;\n", l);
            }
        }

        @Override
        String end() {
            return "return -1;";
        }
    }

    private class PutShift
    extends Puts {
        private PutShift() {
        }

        @Override
        boolean isput(int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            return a.isShift();
        }

        @Override
        void put(PrintStream out, String f, int st, GrammarSymbol g) {
            LRAction a = DecultureTranslatorJava.this.lr.getTable().action(st, (Terminal)g);
            if (a.isShift()) {
                out.printf("\t\t\t\t\treturn %d;\n", a.getNextStateID());
            }
        }

        @Override
        void start(PrintStream out, int st, GrammarSymbol g) {
        }

        @Override
        String end() {
            return "return -1;";
        }
    }

    private class PutStates
    implements ShProcess {
        private PutStates() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
            String d = "";
            int k = 0;
            while (k < DecultureTranslatorJava.this.lr.getTable().getSizeOfStates()) {
                stdout.print(d);
                stdout.print(k);
                d = " ";
                ++k;
            }
            return 0;
        }
    }

    private abstract class Puts
    implements ShProcess {
        private Puts() {
        }

        abstract boolean isput(int var1, GrammarSymbol var2);

        abstract void put(PrintStream var1, String var2, int var3, GrammarSymbol var4);

        abstract void start(PrintStream var1, int var2, GrammarSymbol var3);

        abstract String end();

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
            int k = Integer.parseInt(args[1]);
            Set<Map.Entry<GrammarSymbol, LRAction>> s = DecultureTranslatorJava.this.lr.getTable().actions(k).entrySet();
            String f = "";
            for (Map.Entry<GrammarSymbol, LRAction> e : s) {
                if (!this.isput(k, e.getKey())) continue;
                this.start(stdout, k, e.getKey());
                break;
            }
            for (Map.Entry<GrammarSymbol, LRAction> e : s) {
                if (!this.isput(k, e.getKey())) continue;
                stdout.printf("\t\t\t\tif(__c != null) {\n", new Object[0]);
                stdout.printf("\t\t\t\t\t__t = __c;\n", new Object[0]);
                stdout.printf("\t\t\t\t} else if(__lookahead == null) {\n", new Object[0]);
                stdout.printf("\t\t\t\t\t__t = __lookahead = _next();\n", new Object[0]);
                stdout.printf("\t\t\t\t} else {\n", new Object[0]);
                stdout.printf("\t\t\t\t\t__t = __lookahead;\n", new Object[0]);
                stdout.printf("\t\t\t\t}\n", new Object[0]);
                break;
            }
            for (Map.Entry<GrammarSymbol, LRAction> e : s) {
                if (!this.isput(k, e.getKey())) continue;
                DecultureTranslatorJava.this._put(this, k, e.getKey(), f, stdout);
                f = "} else ";
            }
            if (!f.equals("")) {
                stdout.printf("\t\t\t\t}\n", new Object[0]);
            }
            stdout.printf("\t\t\t\t%s\n", this.end());
            return 0;
        }
    }
}

