/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.LALR1Table;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRConflict;
import net.morilib.automata.lr.LRUtils;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.parser.DecultureAction;
import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.deculture.parser.DecultureReader;
import net.morilib.deculture.translate.DecultureSemanticsException;
import net.morilib.deculture.translate.DecultureSyntaxException;
import net.morilib.deculture.translate.DecultureTranslator;
import net.morilib.deculture.translate.DecultureTranslatorFactory;

public class LRObject {
    private DecultureDefinition def;
    private DecultureAction act;
    private ContextFreeGrammar grammar;
    private LR1Table table;
    private Map<ContextFreeRule, Object> actionMap = new HashMap<ContextFreeRule, Object>();
    private String input;

    public DecultureDefinition getDefinition() {
        return this.def;
    }

    public ContextFreeGrammar getGrammar() {
        return this.grammar;
    }

    public LR1Table getTable() {
        return this.table;
    }

    public Collection<LRConflict> getConflicts() {
        return this.table.getConflicts();
    }

    public Object getAction(ContextFreeRule rule) {
        return this.actionMap.get(rule);
    }

    public void setAction(ContextFreeRule rule, Object action) {
        this.actionMap.put(rule, action);
    }

    public void removeAction(ContextFreeRule rule) {
        this.actionMap.remove(rule);
    }

    public Map<ContextFreeRule, Object> getActionMap() {
        return Collections.unmodifiableMap(this.actionMap);
    }

    public String getInput() {
        return this.input;
    }

    private void _put(ContextFreeGrammar g) {
    }

    public static DecultureTranslator parse(InputStream in) throws IOException {
        StringWriter w = new StringWriter();
        LRObject p = new LRObject();
        char[] a = new char[1024];
        LineNumberReader rd = new LineNumberReader(new InputStreamReader(in));
        try {
            int l;
            p.def = new DecultureDefinition();
            p.def.parseDefinition(new DecultureReader(rd));
            p.act = new DecultureAction(p.def);
            p.act.parseAction(new DecultureReader(rd));
            p.actionMap = p.act.getActions();
            Set<Nonterminal> unused = LRUtils.findUselessNonterminals(p.act.getActions().keySet());
            if (unused.size() > 0) {
                StringBuilder unusedString = new StringBuilder();
                String delim = "";
                for (Nonterminal nonterminal : unused) {
                    unusedString.append(delim).append(nonterminal.toString());
                    delim = ", ";
                }
                throw new DecultureSemanticsException("unusednonterminal", unusedString.toString());
            }
            p.grammar = ContextFreeGrammar.newInstance(p.act.getActions().keySet(), new ConstantNonterminal(p.def.getStartSymbolName()));
            p._put(p.getGrammar());
            p.table = LALR1Table.create(p.grammar, p.def.getPriority(), p.def.getAssociativity(), p.act.getPrecedences());
            while ((l = rd.read(a)) >= 0) {
                w.write(a, 0, l);
            }
            p.input = w.toString();
            return DecultureTranslatorFactory.newInstance(p.def.getLanguage(), p);
        }
        catch (DecultureDefinition.TokenException e) {
            throw new DecultureSyntaxException("definitionerror", rd.getLineNumber() + 1);
        }
        catch (DecultureAction.TokenException e) {
            throw new DecultureSyntaxException("actionerror", rd.getLineNumber() + 1);
        }
    }
}

