/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShExitException;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShPattern;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeExpressionMachine
implements ShTree {
    static final int UNRESOLVED = -1;
    static final int JMP_END = Integer.MAX_VALUE;
    private Code[] codes;

    private ShTreeExpressionMachine(Code ... codes) {
        this.codes = codes;
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        Stack<Iterator<String>> st = new Stack<Iterator<String>>();
        int e = 0;
        int pc = 0;
        while (pc < this.codes.length) {
            if (pc < 0) {
                throw new RuntimeException();
            }
            Code c = this.codes[pc];
            switch (c.mnemonic) {
                case COMP: {
                    e = c.expr.eval(env, fs, cmds, run, in, out, err, p);
                    ++pc;
                    break;
                }
                case JMP: {
                    pc = c.next;
                    break;
                }
                case JMP_Z: {
                    pc = e != 0 ? c.next : pc + 1;
                    break;
                }
                case JMP_NZ: {
                    pc = e != 0 ? pc + 1 : c.next;
                    break;
                }
                case PTN: {
                    String s = ShTrees.substitute(env, run, fs, err, p, c.variable);
                    e = c.pattern.matches(env, fs, run, err, p, s) ? 0 : 1;
                    ++pc;
                    break;
                }
                case PUSHIN: {
                    List<String> ls = ShTrees.substitute(env, run, fs, err, p, c.tokens);
                    st.push(ls.iterator());
                    ++pc;
                    break;
                }
                case GETIN: {
                    String s;
                    if (((Iterator)st.peek()).hasNext()) {
                        s = (String)((Iterator)st.peek()).next();
                        env.bind(c.name, s);
                        ++pc;
                        break;
                    }
                    st.pop();
                    pc = c.next;
                    break;
                }
                case RETURN: {
                    String s;
                    try {
                        s = env.getTrap(ShSignal.RETURN);
                        if (s != null) {
                            run.eval(env, fs, in, out, err, p, s);
                        }
                        s = ShTrees.substitute(env, run, fs, err, p, c.variable);
                        return Integer.parseInt(s);
                    }
                    catch (NumberFormatException x) {
                        return 0;
                    }
                }
                case EXIT: {
                    throw new ShExitException(e);
                }
                case RES: {
                    e = 0;
                    ++pc;
                }
            }
        }
        return e;
    }

    @Override
    public void compileInternally(Builder b, Object brk, Object cnt) {
        b.add(this);
    }

    /* synthetic */ ShTreeExpressionMachine(Code[] codeArray, ShTreeExpressionMachine shTreeExpressionMachine) {
        this(codeArray);
    }

    public static class Builder {
        private Map<Object, Integer> labels;
        private Map<Object, List<Code>> unresolved;
        private List<Code> codes = new ArrayList<Code>();

        public Builder() {
            this.labels = new HashMap<Object, Integer>();
            this.unresolved = new HashMap<Object, List<Code>>();
        }

        public void add(ShTree e) {
            this.codes.add(new Code(Mnemonic.COMP, e, this.codes.size()));
        }

        Code add(Mnemonic m, Object label) {
            Code d;
            if (label == null) {
                d = new Code(m, null, Integer.MAX_VALUE);
                this.codes.add(d);
            } else if (this.labels.containsKey(label)) {
                d = new Code(m, null, this.labels.get(label));
                this.codes.add(d);
            } else {
                d = new Code(m, null, -1);
                this.codes.add(d);
                List<Code> c = this.unresolved.get(label);
                if (c == null) {
                    c = new ArrayList<Code>();
                    this.unresolved.put(label, c);
                }
                c.add(d);
            }
            return d;
        }

        public void addPtn(ShToken variable, ShPattern ptn) {
            Code c = new Code(Mnemonic.PTN, null, -1);
            c.pattern = ptn;
            c.variable = variable;
            this.codes.add(c);
        }

        public void addReturn(ShToken ret) {
            Code c = new Code(Mnemonic.RETURN, null, 0);
            c.variable = ret;
            this.codes.add(c);
        }

        public void addExit() {
            this.codes.add(new Code(Mnemonic.EXIT, null, 0));
        }

        public void addJmp(Object l) {
            this.add(Mnemonic.JMP, l);
        }

        public void addJmpZ(Object l) {
            this.add(Mnemonic.JMP_Z, l);
        }

        public void addJmpNZ(Object l) {
            this.add(Mnemonic.JMP_NZ, l);
        }

        public void addPushin(List<ShToken> ts) {
            Code c = new Code(Mnemonic.PUSHIN, null, -1);
            c.tokens = new ArrayList<ShToken>(ts);
            this.codes.add(c);
        }

        public void addGetin(String s, Object l) {
            this.add((Mnemonic)Mnemonic.GETIN, (Object)l).name = s;
        }

        public void addRes() {
            this.codes.add(new Code(Mnemonic.RES, null, 0));
        }

        public void addLabel(Object label) {
            int addr = this.codes.size();
            List<Code> c = this.unresolved.get(label);
            if (c != null) {
                for (Code d : c) {
                    d.next = addr;
                }
            }
            this.labels.put(label, addr);
        }

        public ShTree get() {
            return new ShTreeExpressionMachine(this.codes.toArray(new Code[0]), null);
        }
    }

    static class Code {
        List<ShToken> tokens;
        ShPattern pattern;
        Mnemonic mnemonic;
        ShToken variable;
        ShTree expr;
        String name;
        int next;

        Code(Mnemonic m, ShTree e, String s, int n) {
            this.mnemonic = m;
            this.expr = e;
            this.next = n;
            this.name = s;
        }

        Code(Mnemonic m, ShTree e, int n) {
            this(m, e, null, n);
        }
    }

    static enum Mnemonic {
        COMP,
        JMP,
        JMP_Z,
        JMP_NZ,
        RES,
        PTN,
        PUSHIN,
        GETIN,
        RETURN,
        EXIT;

    }
}

