/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.conf;

import java.util.Collection;
import java.util.Collections;

import net.morilib.sh.AbstractShFile;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/03
 */
public abstract class SpecialFile extends AbstractShFile {

	/**
	 * 
	 */
	protected String name;

	/**
	 * 
	 * @param fs
	 * @param vp
	 * @param name
	 */
	public SpecialFile(ShFileSystem fs, String vp, String name) {
		super(fs, vp);
		this.name = name;
	}

	public boolean isDirectory() {
		return false;
	}

	public boolean isExist() {
		return true;
	}

	public boolean isFile() {
		return true;
	}

	public boolean isHidden() {
		return false;
	}

	public String getName() {
		return name;
	}

	public Collection<ShFile> getFiles() {
		return Collections.<ShFile>singleton(this);
	}

	public ShProcess getProcess() {
		return null;
	}

	public boolean mkdir() {
		return false;
	}

	public boolean renameTo(ShFile f) {
		return false;
	}

	public boolean rmdir() {
		return false;
	}

	public boolean deleteFile() {
		return false;
	}

}