echo '// Translated by Deculture'
echo '// This source code is under public domain'
cat definition

cat << EOF
function ${CLASSNAME}() {
	this.__stateID = ${INIT_STATE_ID};
	this.__synarray = [];
	this.__synarray.push(this.__stateID);
	this.__synptr = 1;
	this.__lookahead = null;
}
${CLASSNAME}.ENDMARKER = {};
${CLASSNAME}.__ERROR = {};

EOF

echo "${CLASSNAME}.prototype.getShift = function(__c) {"
echo '	switch(this.__stateID) {'
put_shift
echo '	}'
echo '	return -1;'
echo '};'
echo

echo "${CLASSNAME}.prototype.getReduce = function(__c) {"
echo '	var $$, __k;'
echo
echo '	switch(this.__stateID) {'
put_reduce
echo '	}'
echo '	return -1;'
echo '};'
echo

echo "${CLASSNAME}.prototype.isAccept = function(__c) {"
echo '	switch(this.__stateID) {'
put_accept
echo '	}'
echo '	return false;'
echo '};'
echo

echo "${CLASSNAME}.prototype.getGoto = function(__stateID, __n) {"
echo '	switch(__stateID) {'
put_goto
echo '	}'
echo '	throw "Internal error"'
echo '};'
echo

cat << EOF
${CLASSNAME}.prototype._next = function() {
	return this.__lexer.hasNext() ? this.__lexer.next() : ${CLASSNAME}.ENDMARKER;
};

${CLASSNAME}.prototype.__end = function(o) {
	return o === ${CLASSNAME}.ENDMARKER;
};

${CLASSNAME}.prototype.__error = function(o) {
	return o === ${CLASSNAME}.__ERROR;
};

${CLASSNAME}.prototype.__eq = function(o, p) {
	return o === p;
};

${CLASSNAME}.prototype._push = function(k, s) {
	this.__synarray.push(s);
	this.__synarray.push(k);
};

${CLASSNAME}.prototype._pop = function(num) {
	var i;
	for(i = 0; i < num; i++) {
		this.__synarray.pop();
		this.__synarray.pop();
	}
};

${CLASSNAME}.prototype._refsyn = function() {
	return this.__synarray[this.__synarray.length - 1];
};

${CLASSNAME}.prototype._refv = function(n) {
	return this.__synarray[this.__synarray.length - n * 2];
};

${CLASSNAME}.parse = function(lexer) {
	var p = new ${CLASSNAME}(),
		err = false,
		x,
		k;

	p.__lexer = lexer;
	while(true) {
		if(err) {
			if((k = p.getShift(p.__lookahead)) >= 0) {
				p._push(k, p.__lookahead);
				p.__stateID = k;
				err = false;
			} else if((p.__lookahead = p._next()) === ${CLASSNAME}.ENDMARKER) {
				throw 'Syntax Error';
			}
		} else {
			if(p.isAccept(null)) {
				return p._refv(1);
			} else if((k = p.getShift(null)) >= 0) {
				p._push(k, p.__lookahead);
				p.__lookahead = null;
				p.__stateID = k;
			} else if((k = p.getReduce(null)) >= 0) {
				p.__stateID = k;
			} else if(p.__lookahead == ${CLASSNAME}.ENDMARKER) {
				throw 'Syntax Error';
			} else {
				while(p.getShift(${CLASSNAME}.__ERROR) < 0) {
					if(p.__synarray.length <= 1) {
						throw 'Syntax Error';
					}
					p._pop(1);
					p.__stateID = p.__synarray[p.__synarray.length - 1];
				}
				p.__stateID = p.getShift(${CLASSNAME}.__ERROR);
				p._push(k, ${CLASSNAME}.__ERROR);
				err = true;
			}
		}
	}
};
EOF
cat fragment
