/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr;

import java.io.*;
import java.math.*;
import java.text.*;
import java.util.*;
import java.security.*;
import java.sql.*;

public class Database {
	public Connection con;

	private java.util.Date toJavaDate(String d) throws ParseException {
		final DateFormat srcDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		if(d == null) return null;
		return srcDf.parse(d);
	}

	public Database(String dbHost) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
		Class.forName("com.mysql.jdbc.Driver").newInstance();	

		con = DriverManager.getConnection(
			"jdbc:mysql://" + dbHost + "/idlistdb?useUnicode=true&characterEncoding=UTF-8",
			"idlist",
			null);
	}
	
	public void close() throws SQLException {
		con.close();
	}

	/**
	 * JŎ擾
	 */
	public void walkPersonsOrderByOpen(PersonWalker walker) throws Exception {
		Statement state = con.createStatement();
		
		String sql = "select * from PersonHistory, Persons, Users where PersonHistory.PersonID=Persons.PersonID and EditorID=UserID order by OrderID desc";
		ResultSet result = state.executeQuery(sql);

		walker.init();
		
		Statement state2 = con.createStatement();

		while(result.next()) {
			int personId = result.getInt("PersonID");
			Vector<String> aliasNames = null;
	
			ResultSet result2 = state2.executeQuery("select AliasName from PersonAlias where PersonID=" + personId);
			aliasNames = new Vector<String>();
			
			while(result2.next()) {
				aliasNames.addElement(result2.getString("AliasName"));
			}

			result2.close();

			Person person = new Person(
				personId,
				result.getString("Users.Name"),
				result.getString("Persons.Name"),
				result.getInt("Country"),
				toJavaDate(result.getString("CreateDate")),
				toJavaDate(result.getString("ModifyDate")),
				result.getInt("TextType"),
				result.getString("Text"),
				result.getString("Html"),
				result.getString("ShortHtml"),
				toJavaBool(result.getString("Visible")),
				IdlNvr.getInt(result.getString("ShowProfile")),
				result.getInt("EditorID"),
				aliasNames,
				toJavaBool(result.getString("FreeEdit")),
				toJavaBool(result.getString("ShowSubID")),
				result.getString("Memo"));

			walker.walk(person);
		}

		walker.exit();
		
		if(state2 != null) state2.close();
		result.close();
		state.close();
	}
	
	public void walkPersons(int boardId, int country, PersonWalker walker, boolean summary) throws Exception {
		Statement state = con.createStatement();
		
		String sql = "";
	
		if(boardId >= 0) { 
			sql = sql + "select * from Persons, Users, PersonBoard where EditorID=UserID";
			sql = sql + " and Persons.PersonID=PersonBoard.PersonID and BoardID = " + boardId;
		} else {
			sql = sql + "select * from Persons, Users where EditorID=UserID";
		}
		
		if(country > 0) {
			sql = sql + " and Country=\"" + country + "\"";
		}
		
		sql = sql + " order by Persons.Name";

		ResultSet result = state.executeQuery(sql);

		walker.init();
		
		Statement state2 = null;
		
		if(!summary) {
			state2 = con.createStatement();
		}

		while(result.next()) {
			int personId = result.getInt("PersonID");
			Vector<String> aliasNames = null;
	
			if(state2 != null) {
				ResultSet result2 = state2.executeQuery("select AliasName from PersonAlias where PersonID=" + personId);
				aliasNames = new Vector<String>();
				
				while(result2.next()) {
					aliasNames.addElement(result2.getString("AliasName"));
				}
			
				result2.close();
			} else {
				aliasNames = new Vector<String>();
			}

			Person person = new Person(
				personId,
				result.getString("Users.Name"),
				result.getString("Persons.Name"),
				result.getInt("Country"),
				toJavaDate(result.getString("CreateDate")),
				toJavaDate(result.getString("ModifyDate")),
				result.getInt("TextType"),
				result.getString("Text"),
				result.getString("Html"),
				result.getString("ShortHtml"),
				toJavaBool(result.getString("Visible")),
				IdlNvr.getInt(result.getString("ShowProfile")),
				result.getInt("EditorID"),
				aliasNames,
				toJavaBool(result.getString("FreeEdit")),
				toJavaBool(result.getString("ShowSubID")),
				result.getString("Memo"));

			walker.walk(person);
		}

		walker.exit();
		
		if(state2 != null) state2.close();
		result.close();
		state.close();
	}
	
	private static final boolean toJavaBool(String s) {
		return "1".equals(s);
	}
	
	private String calcAuth(String userName, String password, String rand) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");

			md.update(userName.getBytes());
			md.update(password.getBytes());
			md.update(rand.getBytes());

			return new BigInteger(md.digest()).abs().toString(16);
		} catch(NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

	public void updateLastLoginDate(int userId) throws SQLException {
		Statement state = con.createStatement();
		
		state.executeUpdate("update Users set LastLoginDate=\"" + datetimeFormatter.format(new java.util.Date()) + "\" where UserID=" + userId);
		
		state.close();
	}
	
	public User getUser(String userName, String password) throws SQLException, ParseException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where Name=\"" + userName + "\"");
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		String destAuth = result.getString("Password");
		String rand = result.getString("Random");
		
		String srcAuth = calcAuth(userName, password, rand);
		
		if(!destAuth.equals(srcAuth)) {
			return null;
		}

		User user = new User(
			result.getInt("UserID"),
			result.getString("Name"),
			result.getString("Password"),
			result.getString("Profile"),
			IdlNvr.getInt(result.getString("ShowProfile")),
			result.getInt("UserLevel"),
			toJavaDate(result.getString("LastLoginDate")));

		result.close();
		state.close();

		return user;
	}
	
	public User getUser(int userId) throws SQLException, ParseException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where UserID=" + userId);
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		User user = new User(
				result.getInt("UserID"),
				result.getString("Name"),
				result.getString("Password"),
				result.getString("Profile"),
				IdlNvr.getInt(result.getString("ShowProfile")),
				result.getInt("UserLevel"),
				toJavaDate(result.getString("LastLoginDate")));
		
		result.close();
		state.close();

		return user;
	}
	
	public String changePassword(int userId, String userName, String newPassword) throws SQLException {
		Statement state = con.createStatement();

		byte randBytes[] = new byte[16];
		new Random().nextBytes(randBytes);
		String rand = new BigInteger(randBytes).abs().toString(16);
		
		String auth = this.calcAuth(userName, newPassword, rand);
		
		state.executeUpdate("update Users set Password= \"" + auth +  "\", Random=\"" + rand + "\" where UserID=" + userId);

		state.close();
		return null;
	}

	public String registerUser(String userName, String password) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where Name=\"" + userName + "\"");
		
		if(result.next()) {
			result.close();
			state.close();
			return "łɓo^Ă郆[Uł";
		}
		
		result.close();

		byte randBytes[] = new byte[16];
		new Random().nextBytes(randBytes);
		String rand = new BigInteger(randBytes).abs().toString(16);
		
		String auth = this.calcAuth(userName, password, rand);
		
		state.executeUpdate("insert into Users values (" +
				"null, \"" + userName + "\", \"" + auth + "\", " +
				"\"1\", \"0\", 2, \"\", \"0\", \"" + rand + "\", " +
				"\"" + datetimeFormatter.format(new java.util.Date()) +  "\")");

		state.close();
		return null;
	}

	private static Vector<Board> boardList = new Vector<Board>();
	
	public Vector<Board> getBoardList() throws SQLException {
		synchronized(boardList) {
			if(boardList.size() > 0) return boardList;

			Statement state = con.createStatement();
			ResultSet result = state.executeQuery("select * from BoardList");
			
			while(result.next()) {
				Board board = new Board(
					result.getInt("BoardID"), 
					result.getString("BoardName"));
				
				boardList.addElement(board);
			}
	
			result.close();
			state.close();
	
			return boardList;
		}
	}

	private String toSqlText(String o) {
		if(o == null) return "null";

		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");

		return "\"" + s + "\"";
	}
	
	private static SimpleDateFormat datetimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private String toSqlDate(java.util.Date d) {
		if(d == null) return "null";
		String result = "\"" + datetimeFormatter.format(d) + "\"";
		return result;
	}

	public Person registerPerson(int editorId, String name, String country, String detail, String visible, Vector<String> aliasNames, String freeEdit, String showSubId) throws SQLException, ParseException, UnsupportedEncodingException {
		if(getPerson(name, country) != null) return null;

		Statement state = con.createStatement();
		java.util.Date date = new java.util.Date();
//		detail = new String(detail.getBytes("iso-8859-1"), "Shift_JIS");

		String sql = "insert into Persons values(" 
			+ "null,"
			+ editorId + ","
			+ toSqlText(name) + "," 
			+ toSqlText(country) + ","
			+ toSqlDate(date) + ","
			+ toSqlDate(date) + ","
			+ "1,"
			+ toSqlText(detail) + ","
			+ toSqlText(IdlNvr.reviewToHtml(this, detail)) + ","
			+ toSqlText(visible) + ","
			+ toSqlText(IdlNvr.reviewToShortHtml(this, detail)) + ","
			+ toSqlText(freeEdit) + ","
			+ toSqlText(showSubId) + ","
			+ toSqlText("")
			+")";
		
		state.executeUpdate(sql);

		Person person = getPerson(name, country);
		
		if(!"0".equals(visible)) {
			updatePersonHistory(person.personId);
		}

		for(int i=0; i<aliasNames.size(); i++) {
			sql = "insert into PersonAlias values(" 
				+ person.personId + ","
				+ toSqlText(aliasNames.elementAt(i)) + ","
				+ toSqlText(country)
				+ ")";

			state.executeUpdate(sql);
		}
		
		state.close();

		return getPerson(name, country);
	}

	public int getPersonIdFromAlias(String aliasName, String country) throws SQLException {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
				"select PersonID from PersonAlias where AliasName=" 
				+ toSqlText(aliasName)
				+ " and Country=" + toSqlText(country));

		if(!result.next()) {
			result.close();
			state.close();
			return -1;
		}
		
		int personId = result.getInt("PersonID");
		
		result.close();
		state.close();
		
		return personId;
	}
	
	public Person getPerson(String name, String country) throws SQLException, ParseException {
		Statement state = con.createStatement();
		ResultSet result = state.executeQuery(
				"select * from Persons, Users where Persons.Name=" + toSqlText(name)
				+ " and Country=" + toSqlText(country) +  " and UserID=EditorID");

		if(!result.next()) {
			state.close();
			result.close();
			return null;
		}

		Statement state2 = con.createStatement();

		int personId = result.getInt("PersonID");
		
		ResultSet result2 = state2.executeQuery("select AliasName from PersonAlias where PersonID=" + personId);
		Vector<String> aliasNames = new Vector<String>();
		
		while(result2.next()) {
			aliasNames.addElement(result2.getString("AliasName"));
		}
		
		result2.close();

		Person person = new Person(
			personId,
			result.getString("Users.Name"),
			result.getString("Persons.Name"),
			result.getInt("Country"),
			toJavaDate(result.getString("CreateDate")),
			toJavaDate(result.getString("ModifyDate")),
			result.getInt("TextType"),
			result.getString("Text"),
			result.getString("Html"),
			result.getString("ShortHtml"),
			toJavaBool(result.getString("Visible")),
			IdlNvr.getInt(result.getString("ShowProfile")),
			result.getInt("EditorID"),
			aliasNames,
			toJavaBool(result.getString("FreeEdit")),
			toJavaBool(result.getString("ShowSubID")),
			result.getString("Memo"));

		state2.close();
		state.close();
		result.close();
		return person;
	}
	
	public Person getPerson(int personId) throws SQLException, ParseException {
		Statement state = con.createStatement();
		ResultSet result = state.executeQuery(
				"select * from Persons, Users where PersonID=" + personId  +  " and UserID=EditorID");

		if(!result.next()) {
			state.close();
			result.close();
			return null;
		}
		
		Statement state2 = con.createStatement();

		ResultSet result2 = state2.executeQuery("select AliasName from PersonAlias where PersonID=" + personId);
		Vector<String> aliasNames = new Vector<String>();
		
		while(result2.next()) {
			aliasNames.addElement(result2.getString("AliasName"));
		}
		
		result2.close();

		Person person = new Person(
			personId,
			result.getString("Users.Name"),
			result.getString("Persons.Name"),
			result.getInt("Country"),
			toJavaDate(result.getString("CreateDate")),
			toJavaDate(result.getString("ModifyDate")),
			result.getInt("TextType"),
			result.getString("Text"),
			result.getString("Html"),
			result.getString("ShortHtml"),
			toJavaBool(result.getString("Visible")),
			IdlNvr.getInt(result.getString("ShowProfile")),
			result.getInt("EditorID"),
			aliasNames,
			toJavaBool(result.getString("FreeEdit")),
			toJavaBool(result.getString("ShowSubID")),
			result.getString("Memo"));

		state2.close();
		state.close();
		result.close();
		return person;
	}
	
	public void clearPersonBoard(int personId) throws SQLException {
		Statement state = con.createStatement();
		state.executeUpdate("delete from PersonBoard where PersonID=" + personId);
		state.close();
	}
	
	public void insertPersonBoard(int personId, int boardId) throws SQLException {
		Statement state = con.createStatement();
		state.executeUpdate("insert into PersonBoard values (" + personId + "," + boardId + ")");
		state.close();
	}
	
	public void refleshBoardList() throws SQLException {
		synchronized(boardList) {
			Statement state = con.createStatement();
			state.executeUpdate("delete from BoardList");

			state.executeUpdate("insert into BoardList values(0, \"eLXg-X|[c\")");
			state.executeUpdate("insert into BoardList values(1, \"eLXg-|\\")");
			state.executeUpdate("insert into BoardList values(2, \"Hot\")");
			state.executeUpdate("insert into BoardList values(3, \"C[W-X|[c\")");
			state.executeUpdate("insert into BoardList values(4, \"C[W-|\\")");
			state.executeUpdate("insert into BoardList values(6, \"eLXg-Q[\")");
			state.executeUpdate("insert into BoardList values(7, \"\")");
			state.executeUpdate("insert into BoardList values(8, \"j\")");
			state.executeUpdate("insert into BoardList values(11, \"C[W-Aj\")");
			state.executeUpdate("insert into BoardList values(12, \"wZ\")");
			state.executeUpdate("insert into BoardList values(13, \"C[W-`\")");
			state.executeUpdate("insert into BoardList values(14, \"FB\")");
			state.executeUpdate("insert into BoardList values(15, \"lbg/PC\")");
			state.executeUpdate("insert into BoardList values(16, \"\")");
			state.executeUpdate("insert into BoardList values(17, \"X\")");
			state.executeUpdate("insert into BoardList values(18, \"C[W-s\")");
			state.executeUpdate("insert into BoardList values(19, \"\")");
			state.executeUpdate("insert into BoardList values(23, \"eLXg-s\")");
			state.executeUpdate("insert into BoardList values(26, \"eLXg-Aj\")");
			state.executeUpdate("insert into BoardList values(27, \"f\")");
			state.executeUpdate("insert into BoardList values(28, \"K-POP\")");
			state.executeUpdate("insert into BoardList values(29, \"eLXg-[A\")");
			state.executeUpdate("insert into BoardList values(30, \"ybg\")");
			state.executeUpdate("insert into BoardList values(31, \"O\")");
			state.executeUpdate("insert into BoardList values(32, \"̎\")");
			state.executeUpdate("insert into BoardList values(33, \"vf\")");
			state.executeUpdate("insert into BoardList values(34, \"oCN\")");
			state.executeUpdate("insert into BoardList values(35, \"C[W-Q[\")");
			state.executeUpdate("insert into BoardList values(36, \"߃X|bg\")");
			state.executeUpdate("insert into BoardList values(37, \"J-POP\")");
			state.executeUpdate("insert into BoardList values(38, \"؍h}\")");
			state.executeUpdate("insert into BoardList values(39, \"{h}\")");
			state.executeUpdate("insert into BoardList values(40, \"RXv\")");
			state.executeUpdate("insert into BoardList values(41, \"\")");
			state.executeUpdate("insert into BoardList values(42, \"f\")");
			state.executeUpdate("insert into BoardList values(43, \"ʐ^\")");
			state.executeUpdate("insert into BoardList values(44, \"C[W-[A\")");
			state.executeUpdate("insert into BoardList values(45, \"R\")");
			state.executeUpdate("insert into BoardList values(46, \"t@bV\")");
			state.executeUpdate("insert into BoardList values(47, \"J\")");
			state.executeUpdate("insert into BoardList values(48, \"di\")");
			
			state.close();
			boardList.clear();
		}
	}
	
	public Vector<Comment> getComments(int personId) throws SQLException, ParseException {
		Vector<Comment> comments = new Vector<Comment>();
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select * from Comments, Users where Comments.UserID=Users.UserID and PersonID=" + personId + " order by CommentID");

		while(result.next()) {
			Comment comment = new Comment(
				result.getString("Users.Name"),
				toJavaDate(result.getString("CreateDate")),
				result.getString("Comment"),
				result.getInt("CommentID"),
				result.getInt("UserID"));
			
			comments.addElement(comment);
		}
		
		result.close();
		state.close();

		return comments;
	}
	
	public Vector<Board> getPersonBoard(int personId) throws SQLException {
		Vector<Board> boards = new Vector<Board>();
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select * from PersonBoard, BoardList" +
			" where PersonBoard.BoardID=BoardList.BoardID" +
			" and PersonID=" + personId +
			" order by PersonBoard.BoardID");

		while(result.next()) {
			Board board = new Board(
				result.getInt("BoardID"),
				result.getString("BoardName"));
			
			boards.addElement(board);
		}
		
		result.close();
		state.close();

		return boards;
	}
	
	public void postComment(int personId, int userId, String comment) throws SQLException, UnsupportedEncodingException {
		Statement state = con.createStatement();
//		comment = new String(comment.getBytes("iso-8859-1"), "Shift_JIS");
		
		state.executeUpdate(
			"insert into Comments values("
			+ "null,"
			+ personId + ","
			+ toSqlDate(new java.util.Date()) + ","
			+ userId + ","
			+ toSqlText(IdlNvr.toHtmlText(comment))
			+ ")");
	}
	
	public String updatePerson(int personId, String editorName, String detail, String visible, String newPersonName, String newCountry, Vector<String> aliasNames, String freeEdit, String showSubId) throws SQLException, UnsupportedEncodingException {
		Statement state = con.createStatement();
//		detail = new String(detail.getBytes("iso-8859-1"), "Shift_JIS");

		ResultSet result = state.executeQuery(
			"select * from Users where UserLevel>=\"3\" and Name=" + toSqlText(editorName));
		
		if(!result.next()) {
			result.close();
			state.close();
			return "݂ȂҏWҖAҏWȂ[Uł";
		}
		
		int editorId = result.getInt("UserID");
		result.close();

		result = state.executeQuery(
			"select * from Persons where " +
			"Name=" + toSqlText(newPersonName)
			+ " and Country=" + toSqlText(newCountry)
			+ " and PersonID!=" + personId);
	
		if(result.next()) { 
			result.close();
			state.close();
			return "w肳ꂽID͊ɑ݂܂";
		}
		
		result.close();
		
		state.executeUpdate(
			"update Persons set" +
			" EditorID=" + editorId + 
			",Text=" + toSqlText(detail) + 
			",Html=" + toSqlText(IdlNvr.reviewToHtml(this, detail)) +
			",ModifyDate=" + toSqlDate(new java.util.Date()) + 
			",Visible=" + toSqlText(visible) + 
			",Name=" + toSqlText(newPersonName) + 
			",Country=" + toSqlText(newCountry) +
			",ShortHtml=" + toSqlText(IdlNvr.reviewToShortHtml(this, detail)) +
			",FreeEdit=" + toSqlText(freeEdit) + 
			",ShowSubID=" + toSqlText(showSubId) +
			" where PersonID=" + personId);

		state.executeUpdate("delete from PersonAlias where PersonID=" + personId);
		
		for(int i=0; i<aliasNames.size(); i++) {
			state.executeUpdate("insert into PersonAlias values(" 
				+ personId + ","
				+ toSqlText(aliasNames.elementAt(i)) + ","
				+ toSqlText(newCountry)
				+ ")");
		}

		state.close();

		if(!"0".equals(visible)) updatePersonHistory(personId);
		
		return null;
	}
	
	public String updateHtmlDetail(int personId, String newHtmlDetail, String newShortHtmlDetail) throws SQLException, UnsupportedEncodingException {
		Statement state = con.createStatement();

		state.executeUpdate(
			"update Persons set Html=" + toSqlText(newHtmlDetail) +
			",ShortHtml=" + toSqlText(newShortHtmlDetail) +  
			" where PersonID=" + personId);

		state.close();
		return null;
	}

	public Vector<User> getUsers() throws SQLException, ParseException {
		Vector<User> users = new Vector<User>();
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users order by UserID");
		
		while(result.next()) {
			User user = new User(
					result.getInt("UserID"),
					result.getString("Name"),
					result.getString("Password"),
					result.getString("Profile"),
					IdlNvr.getInt(result.getString("ShowProfile")),
					result.getInt("UserLevel"),
					toJavaDate(result.getString("LastLoginDate")));

			users.addElement(user);
		}
		
		result.close();
		state.close();

		return users;
	}
	

	public int getCommentNum() throws SQLException {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select count(*) as cnt from Comments");
		
		result.next();
		int num = result.getInt("cnt");
		
		result.close();
		state.close();
		return num;
	}
	
	public Vector<CommentListItem> getCommentList(int start, int num) throws SQLException, ParseException {
		Vector<CommentListItem> comments = new Vector<CommentListItem>();
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select "
			+ " EditorUsers.Name as EditorName, "
			+ " Persons.Name as PersonName, "
			+ " Persons.Country as PersonCountry, "
			+ " PosterUsers.Name as PosterName, "
			+ " Comments.CreateDate as CreateDate, "
			+ " Comments.Comment as Comment, "
			+ " CommentID "
			+ "from Comments, Persons, Users as EditorUsers, Users as PosterUsers "
			+ "where "
			+ " Comments.PersonID = Persons.PersonID "
			+ " and Comments.UserID = PosterUsers.UserID "
			+ " and Persons.EditorID=EditorUsers.UserID "
			+ " order by CommentID desc "
			+ " limit " + start + "," + num);

		while(result.next()) {
			CommentListItem comment = new CommentListItem(
			result.getString("EditorName"),
			result.getString("PersonName"),
			IdlNvr.getInt(result.getString("PersonCountry")),
			result.getString("PosterName"),
			toJavaDate(result.getString("CreateDate")),
			result.getString("Comment"),
			result.getInt("CommentID"));
				
			comments.addElement(comment);
		}
		
		result.close();
		state.close();

		return comments;
		
	}

	public Vector<Person> getNewPersons() throws SQLException, ParseException {
		int boardId = -1;
		int country = -1;
		
		Vector<Person> persons = new Vector<Person>();
		Statement state = con.createStatement();
		
		String sql = "select * from Persons, Users where EditorID=UserID";
	
		if(boardId >= 0) { 
			sql = sql + " and BoardID = " + boardId;
		}
		
		if(country > 0) {
			sql = sql + " and Country=\"" + country + "\"";
		}
		
		sql = sql + " order by PersonID desc";

		ResultSet result = state.executeQuery(sql);

		Statement state2 = con.createStatement();

		while(result.next()) {
			int personId = result.getInt("PersonID");
			
			ResultSet result2 = state2.executeQuery("select AliasName from PersonAlias where PersonID=" + personId);
			Vector<String> aliasNames = new Vector<String>();

			while(result2.next()) {
				aliasNames.addElement(result2.getString("AliasName"));
			}

			result2.close();

			Person person = new Person(
				result.getInt("PersonID"),
				result.getString("Users.Name"),
				result.getString("Persons.Name"),
				result.getInt("Country"),
				toJavaDate(result.getString("CreateDate")),
				toJavaDate(result.getString("ModifyDate")),
				result.getInt("TextType"),
				result.getString("Text"),
				result.getString("Html"),
				result.getString("ShortHtml"),
				toJavaBool(result.getString("Visible")),
				IdlNvr.getInt(result.getString("ShowProfile")),
				result.getInt("EditorID"),
				aliasNames,
				toJavaBool(result.getString("FreeEdit")),
				toJavaBool(result.getString("ShowSubID")),
				result.getString("Memo"));
			
			persons.addElement(person);
		}

		state2.close();
		result.close();
		state.close();
		
		return persons;
	}
	
	public void deletePerson(int personId) throws SQLException {
		Statement state = con.createStatement();
		
		state.executeUpdate(
			"delete from Persons where PersonID=" + personId);
		state.executeUpdate(
				"delete from Comments where PersonID=" + personId);
		state.executeUpdate(
				"delete from PersonBoard where PersonID=" + personId);
		state.executeUpdate(
				"delete from PersonHistory where PersonID=" + personId);
		state.executeUpdate(
				"delete from PersonAlias where PersonID=" + personId);

		state.close();
	}
	
	public int getVisibleIdNum() throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select count(*) as cnt from Persons where Visible=\"1\"");
		result.next();
		int idnum = result.getInt("cnt");
		
		result.close();
		state.close();

		return idnum;
	}

	public Comment getComment(int commentId) throws Exception {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
				"select * from Comments, Users where Comments.UserID=Users.UserID and CommentID=" + commentId);

		if(!result.next()) throw new Exception("݂ȂRgł");

		Comment comment = new Comment(
			result.getString("Users.Name"),
			toJavaDate(result.getString("CreateDate")),
			result.getString("Comment"),
			result.getInt("CommentID"),
			result.getInt("UserID"));
		
		result.close();
		state.close();

		return comment;
	}

	public void deleteComment(int commentId) throws SQLException {
		Statement state = con.createStatement();
		
		state.executeUpdate("delete from Comments where CommentID=" + commentId);
		state.close();
	}
	
	public void updateUserLevel(int userId, int userLevel) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Users set UserLevel=" + userLevel +  " where UserID=" + userId);
		state.close();
	}

	public void updateUser(int userId, String profileLevel, String profile) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate(
			"update Users set ShowProfile=" + toSqlText(profileLevel) 
			+", profile=" + toSqlText(profile)
			+  " where UserID=" + userId);
		
		state.close();
	}
	
	public void updatePersonHistory(int personId) throws SQLException {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select * from PersonHistory where PersonID=" + personId);
			
		if(result.next()) {
			result.close();
			state.close();
			return;
		}

		result.close();
		
		state.executeUpdate(
			"insert into PersonHistory values (NULL, " + personId + ")");
		
		state.close();
	}

	public String getVisibleNewIdHtml() throws SQLException {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery(
			"select max(OrderID) as lastorder from PersonHistory, Persons where PersonHistory.PersonID = Persons.PersonID and Visible=1");
		
		if(!result.next()) {
			result.close();
			state.close();
			return "";
		}

		int lastorder = result.getInt("lastorder");
		
		result.close();

		result = state.executeQuery(
				"select Name, Country from PersonHistory, Persons where PersonHistory.PersonID = Persons.PersonID and OrderID=" + lastorder);
		
		if(!result.next()) {
			result.close();
			state.close();
			return "N/A";
		}
		
		String id = result.getString("Name");
		String country = result.getString("Country");
		
		String newid = "<a href=\"./detail?id=" + id + "&c=" + country + "\">" + id + "</a>";

		result.close();
		state.close();

		return newid;
	}

	public Vector<String> getSkipWords() throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Skipwords");
		Vector<String> skipWords = new Vector<String>();

		while(result.next()) {
			skipWords.addElement(result.getString("Word"));
		}

		result.close();
		state.close();

		return skipWords;
	}
	
	public void migrateUsers() throws SQLException {
		Statement state = con.createStatement();

		ResultSet result = state.executeQuery("select * from OldUsers");
		
		while(result.next()) {
			String userName = result.getString("Name");
			int userId = result.getInt("UserID");
			String password = result.getString("Password");

			byte randBytes[] = new byte[16];
			new Random().nextBytes(randBytes);
			String rand = new BigInteger(randBytes).abs().toString(16);
			
			String auth = this.calcAuth(userName, password, rand);

			state.executeUpdate("update Users set Password= \"" + auth +  "\", Random=\"" + rand + "\", LastLoginDate=\"2005-01-01 00:00:00\" where UserID=" + userId);
		}
		
		result.close();

		state.close();
	}
	
	public String getBoardListText() throws SQLException {
		Statement state = con.createStatement();
		String text = "";

		ResultSet result = state.executeQuery("select * from BoardList");
		
		while(result.next()) {
			int boardId = result.getInt("BoardID");
			String boardName = result.getString("BoardName");
			
			text = text + boardId + ":" + boardName + "\n";
		}
		
		result.close();
		state.close();
		
		return text;
	}

	public void setBoardListText(String text) throws SQLException, IOException {
		BufferedReader reader = new BufferedReader(new StringReader(text));

		String line;
		Vector<Board> boards = new Vector<Board>();
		
		while((line = reader.readLine()) != null) {
			int pos = line.indexOf(':');
			int boardId = Integer.parseInt(line.substring(0, pos));
			String boardName = line.substring(pos+1);
			
			boards.addElement(new Board(boardId, boardName));
		}
		
		reader.close();
		Statement state = con.createStatement();

		state.executeUpdate("delete from BoardList");
		
		for(Board board: boards) {
			state.executeUpdate("insert into BoardList values(" 
				+ board.boardId + ", "
				+ toSqlText(board.name)+ ")");
		}
		
		state.close();
	}

	public void changeUserName(int userId, String userName) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Users set Name=" + toSqlText(userName) +  " where UserID=" + userId);
		state.close();
	}
	
	public void updateMemo(int personId, String memo) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Persons set Memo=" + toSqlText(memo) + " where PersonID=" + personId);

		state.close();
	}
}
