/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.idlnvr.*;

public abstract class BaseServlet extends HttpServlet {
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGet(request, response);
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");

			HttpSession session = request.getSession(true);
			PrintWriter out = response.getWriter();
			String dbHost = request.getSession().getServletContext().getInitParameter("DBHost");

			Database db = new Database(dbHost);

			User user = (User)session.getAttribute("user");
			if(user == null) {
				user = User.getGuest();
				session.setAttribute("user", user);
			}

			out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
			out.println("<title>NAVER IDT</title>");
			addHtmlHeader(request, response, out, db, user);
			out.println("</head><body>");

			out.println("<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
			
			out.println("<a href=\"./\">v</a>");
			out.println("<a href=\"./?s=1\">S</a>");
			
			if(user.isGuest) {
				out.println("<a href=\"./login\">OC</a>");
				out.println("<a href=\"./register\"></a>");
			}

			if(!user.isGuest) {
				out.println("<a href=\"./logout\">OAEg</a>");
			}

			if(user.allowEdit) {
				out.println("<a href=\"./newid\">VKIDo^</a>");
			}

			out.println("<a href=\"./usage.html\">gp@</a>");
				
			if(!user.isGuest) {
				out.println("<a href=\"./personlist\">IDV</a>");
				out.println("<a href=\"./commentlist\">RgV</a>");
			}

			if(user.allowEdit) {
				out.println("<a href=\"./editor\">lݒ</a>");
			}

			if(!user.isGuest) {
				out.println("<a href=\"./changepassword\">pX[hύX</a>");
			}

			if(user.isChiefEditor)  {
				out.println("<a href=\"./manager\">Ǘ</a>");
			}
			
			if(hasRequiredUserLevel(user)) {
				dispLeftHeader(request, response, out, db, user);
			}
			
			out.println("</td><td align=\"right\">");

			if(hasRequiredUserLevel(user)) {
				dispRightHeader(request, response, out, db, user);
			}
			
			out.println("<a href=\"./history\">" + db.getVisibleIdNum() + "IDs</a> "
					+ "V:<b>" + db.getVisibleNewIdHtml() + "</b>");
			
			out.println("</td></tr></table>");
			
			out.println("<hr>");

			if(hasRequiredUserLevel(user)) {
				dispContents(request, response, out, db, user);
			} else {
				out.println(getUserLevelErrorMessage() + "<br>");
			}
			
			out.println("</body></html>");

			db.close();
			out.close();
		
		} catch(Exception e) {
			try {
				PrintWriter out = response.getWriter();
				e.printStackTrace(out);
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	private boolean hasRequiredUserLevel(User user) {
		switch(getRequiredUserLevel()) {
		case User.USER_LEVEL_DISABLED: return false;
		case User.USER_LEVEL_ANONYMOUS: return true;
		case User.USER_LEVEL_LOGIN: return !user.isGuest;
		case User.USER_LEVEL_EDITOR: return user.allowEdit;
		case User.USER_LEVEL_CHIEF_EDITOR: return user.isChiefEditor;
		case User.USER_LEVEL_ADMIN: return false;
		default: return false;
		}
	}

	private String getUserLevelErrorMessage() {
		switch(getRequiredUserLevel()) {
		case User.USER_LEVEL_DISABLED: return "̃AJEg͖Ă܂";
		case User.USER_LEVEL_ANONYMOUS: return "֎~Ă鑀ł";
		case User.USER_LEVEL_LOGIN: return "OCĂ܂";
		case User.USER_LEVEL_EDITOR: return "ҏW܂";
		case User.USER_LEVEL_CHIEF_EDITOR: return "required role: '<i>USER_LEVEL_CHIEF_EDITOR</i>'.";
		case User.USER_LEVEL_ADMIN: return "required role: '<i>USER_LEVEL_ADMIN</i>'.";
		default: return "KvȌ܂";
		}
	}

	protected abstract void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception;
	protected abstract int getRequiredUserLevel();

	protected void dispLeftHeader(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) {}
	protected void dispRightHeader(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) {}

	protected void addHtmlHeader(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) {}
}
