/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class CommentListServlet extends BaseServlet {
	private static final SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_LOGIN;
	}

	private static final int COMMENTS_PER_PAGE = 30;
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		int page = IdlNvr.getInt(request.getParameter("p"));
		if(page == -1) page = 0;
		int commentNum = db.getCommentNum();
		
		Vector<CommentListItem> comments = db.getCommentList(page * COMMENTS_PER_PAGE, COMMENTS_PER_PAGE);

//		out.println("t ҏW(ҏWΏID) <b>eҁF</b> Rg<hr>");

		out.print("page: ");
		
		for(int i=0; i<commentNum / COMMENTS_PER_PAGE + 1; i++) {
			if(i == page) out.println("<b>" + (i+1) + "</b>");
			else if(i == 0) out.println("<a href=\"./commentlist\">1</a>");
			else out.println("<a href=\"./commentlist?p=" + i + "\">" + (i+1) + "</a>");
 		}

		out.println("<hr>");
		
		for(int i=0; i<comments.size(); i++) {
			CommentListItem comment = comments.elementAt(i);

			out.println(
				comment.commentId + ". <b>" + comment.poster + "</b> "
				+ df.format(comment.date) + " "
				+ "(" + comment.editorName + " "
				+ IdlNvr.getCountryString(comment.personCountry) 
				+ " <a href=\"./detail?id=" + comment.personName + "&c=" + comment.personCountry +  "#" + comment.commentId + "\">" + comment.personName + "</a>) "
				+ "<br>"
				+ comment.text);

			out.println("<hr>");
		}

		out.print("page: ");
		
		for(int i=0; i<commentNum / COMMENTS_PER_PAGE + 1; i++) {
			if(i == page) out.println("<b>" + (i+1) + "</b>");
			else if(i == 0) out.println("<a href=\"./commentlist\">1</a>");
			else out.println("<a href=\"./commentlist?p=" + i + "\">" + (i+1) + "</a>");
 		}

		out.println("<hr>");
	}
}
