/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;


import java.io.*;
import java.text.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class DeletePersonServlet extends BaseServlet {
	private static SimpleDateFormat ldf = new SimpleDateFormat("yy/MM/dd HH:mm:ss");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_EDITOR;
	}
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String id = request.getParameter("id");
		String country = request.getParameter("c");

		Person person = db.getPerson(id, country);

		if(!user.name.equals(person.editorName)) {
			out.println("ID̕ҏW҂ł͂܂<br>");
			return;
		}

		out.println("ID: <b>" + person.name + "</b><br>");
		out.println(": " + IdlNvr.getCountryString(person.country) + "<br>");
		out.println("쐬: " + ldf.format(person.createDate) + "<br>");
		out.println("XV: " + ldf.format(person.modifyDate) + "<br>");

		out.println("<form method=post action=\"./deletepersonresult\">");

		out.println("<input type=hidden name=p value=\"" + person.name + "\">");
		out.println("<input type=hidden name=c value=\"" + person.country + "\">");
		out.println("<br>");
		out.println("폜܂B낵łH");

		out.println("<input type=\"submit\" value=\"폜\">");
		out.println("</form>");
	}
}
