/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;

import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class EditorServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_EDITOR;
	}
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		out.println("<form method=post action=\"./editorresult\">");
		out.println("ҏWҖF" + user.name + "<br>");

		out.println("ӂ̌J: <select name=\"profilelevel\">");
		out.println("<option value=\"0\" " + (user.profileLevel == 0 ? "selected" : "") + ">J");
		out.println("<option value=\"1\" " + (user.profileLevel == 1 ? "selected" : "") + ">ҏW҂ɌJ");
		out.println("<option value=\"2\" " + (user.profileLevel == 2 ? "selected" : "") + ">OC[UɌJ");
		out.println("<option value=\"3\" " + (user.profileLevel == 3 ? "selected" : "") + ">SɌJ");
		out.println("</select><br>");

		out.println("ҏWj: <br>");

		out.println("<textarea name=\"profile\" cols=80 rows=20>" + user.profile + "</textarea><br><br>");
		out.println("<input type=\"submit\" value=\"XV\">");
		out.println("</form>");
	}
}
