/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.http.*;
import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class HistoryServlet  extends BaseServlet {
	private static final DateFormat df = new SimpleDateFormat("yyyy/MM/dd");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_ANONYMOUS;
	}
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter _out, Database db, User _user) throws Exception {
		final PrintWriter out = _out;
		final User user = _user;
		
		db.walkPersonsOrderByOpen(new PersonWalker() {
			public void init() {
				out.println("͏JŐVAt͍ŏIXVłB<br><br>");
			}
			
			public void walk(Person person) throws Exception {
				if(!person.visible && user.isGuest) return;

				out.print(df.format(person.modifyDate) + " ");
				out.print(IdlNvr.getCountryString(person.country) + " ");
				out.print("<a name=\"" +  person.personId + "\"></a> ");
				out.print("<b><a href=\"./detail?id=" + person.name + "&c=" + person.country + "\"><font color=black>" + person.name + "</font></a></b> ");
				out.println("<br>");
			}
			
			public void exit() {
				out.println("<hr>");
				out.println("Powered by idlNVR " + IdlNvr.VERSION);
			}
		});
	}
}
