/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.text.*;
import java.util.*;

import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class ManagerServlet extends BaseServlet {
	private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_CHIEF_EDITOR;
	}

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String cmd = request.getParameter("cmd");

		if(cmd == null || cmd.equals("")) dispMain(out, request, response, db);
		else if(cmd.equals("refleshBoardList")) refleshBoardList(out, request, response, db);
		else if(cmd.equals("reconvertReview")) reconvertReview(out, request, response, db);
		else if(cmd.equals("dispUsers")) dispUsers(out, request, response, db);
		else if(cmd.equals("dispUser")) dispUser(out, request, response, db);
		else if(cmd.equals("changeUserLevel")) changeUserLevel(out, request, response, db);
		else if(cmd.equals("impersonateUser")) impersonateUser(out, request, response, db);
		else if(cmd.equals("dispBoardListText")) dispBoardListText(out, request, response, db);
		else if(cmd.equals("setBoardListText")) setBoardListText(out, request, response, db);
		else if(cmd.equals("dispUsageText")) dispUsageText(out, request, response, db);
		else if(cmd.equals("setUsageText")) setUsageText(out, request, response, db);
		else if(cmd.equals("changeUserName")) changeUserName(out, request, response, db);
	}

	private void dispMain(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		out.println("<form action=\"./manager\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"cmd\" value=\"dispBoardListText\">");
		out.println("	<input type=\"submit\" value=\"ꗗҏW...\">");
		out.println("</form>");

		out.println("<form action=\"./manager\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"cmd\" value=\"reconvertReview\">");
		out.println("	<input type=\"submit\" value=\"r[ĕϊ\">");
		out.println("</form>");

		out.println("<form action=\"./manager\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"cmd\" value=\"dispUsers\">");
		out.println("	<input type=\"submit\" value=\"[Uꗗ...\">");
		out.println("</form>");

		out.println("<form action=\"./manager\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"cmd\" value=\"dispUsageText\">");
		out.println("	<input type=\"submit\" value=\"gp@ҏW...\">");
		out.println("</form>");
	}

	private void refleshBoardList(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		db.refleshBoardList();
		
		out.println("");
	}

	private void reconvertReview(PrintWriter out, HttpServletRequest request, HttpServletResponse response, final Database db) throws Exception {
		db.walkPersons(-1, -1, new PersonWalker() {
			public void init() {}
			public void exit() {}
			
			public void walk(Person person) throws Exception {
				db.updateHtmlDetail(
					person.personId, 
					IdlNvr.reviewToHtml(db, person.text),
					IdlNvr.reviewToShortHtml(db, person.text));
			}
		}, true);

		out.println("done");
	}

	private void dispUsers(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		Vector<User> users = db.getUsers();

		out.println("<table border=\"1\">");
		
		for(int i=0; i<users.size(); i++) {
			User user = users.elementAt(i);

			out.print("<tr>");
			out.print("<td>" + user.userId + ".</td>");
			out.print("<td>" + "<a href=\"./manager?cmd=dispUser&userid=" + user.userId + "\">" + user.name + "</a> " + "</td>");
			out.print("<td>" + df.format(user.lastLoginDate) + "</td>");
			out.println("</tr>");
		}

		out.println("</table>");
	}

	private void dispUser(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		int userId = IdlNvr.getInt(request.getParameter("userid"));
		User user = db.getUser(userId);

		out.println("UserID: " + user.userId + "<br>");
		out.println("LastLoginDate: " + df.format(user.lastLoginDate) + "<br>");

		out.println("<form method=post action=\"./manager\">");
		out.println("<input type=\"hidden\" name=\"cmd\" value=\"changeUserName\">");
		out.println("<input type=\"hidden\" name=\"userid\" value=\"" + user.userId + "\">");
		out.println("Name: <input type=\"text\" name=\"userName\" value=\"" + user.name + "\">");
		out.println("<input type=\"submit\" value=\"Change User Name\">");
		out.println("</form>");

		out.println("<form method=post action=\"./manager\">");
		out.println("<input type=\"hidden\" name=\"cmd\" value=\"changeUserLevel\">");
		out.println("<input type=\"hidden\" name=\"userid\" value=\"" + user.userId + "\">");
		out.println("User RoleF <select name=\"userlevel\">");
		out.println("<option value=\"0\" " + (user.userLevel == 0 ? "selected" : "") + ">DISABLED");
		out.println("<option value=\"1\" " + (user.userLevel == 1 ? "selected" : "") + ">ANONYMOUS");
		out.println("<option value=\"2\" " + (user.userLevel == 2 ? "selected" : "") + ">LOGIN");
		out.println("<option value=\"3\" " + (user.userLevel == 3 ? "selected" : "") + ">EDITOR");
		out.println("<option value=\"4\" " + (user.userLevel == 4 ? "selected" : "") + ">CHIEF_EDITOR");
		out.println("<option value=\"5\" " + (user.userLevel == 5 ? "selected" : "") + ">ADMIN");
		out.println("</select>");
		out.println("<input type=\"submit\" value=\"Change User Level\">");
		out.println("</form>");
		
		out.println("<form method=post action=\"./manager\">");
		out.println("<input type=\"hidden\" name=\"cmd\" value=\"impersonateUser\">");
		out.println("<input type=\"hidden\" name=\"userid\" value=\"" + user.userId + "\">");
		out.println("<input type=\"submit\" value=\"Impersonate User\">");
		out.println("</form>");
	}

	private void changeUserLevel(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		int userId = IdlNvr.getInt(request.getParameter("userid"));
		int userLevel = IdlNvr.getInt(request.getParameter("userlevel"));
		
		db.updateUserLevel(userId, userLevel);

		out.println("done");
	}

	private void impersonateUser(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		HttpSession session = request.getSession(true);

		int userId = IdlNvr.getInt(request.getParameter("userid"));
		User user = db.getUser(userId);

		session.setAttribute("user", user);

		out.println("<script>");
		out.println("<!--");
		out.println("location.href=\"./\";");
		out.println("// -->");
		out.println("</script>");
	}
	
	private void dispBoardListText(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		String text = db.getBoardListText();

		out.println("<form method=post action=\"./manager\">");
		out.println("<input type=\"hidden\" name=\"cmd\" value=\"setBoardListText\">");
		out.println("<textarea name=\"boardListText\" cols=80 rows=40>" + text + "</textarea><br><br>");
		out.println("<input type=\"submit\" value=\"XV\">");
		out.println("</form>");
	}

	private void setBoardListText(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		String boardListText = request.getParameter("boardListText");

		db.setBoardListText(boardListText);
		
		out.println("done");
	}

	private void dispUsageText(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		String rootDir = request.getSession().getServletContext().getInitParameter("RootDir");
		String fileName = rootDir + "usage.html";
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName), "MS932"));
		String text = "";
		String line;
		
		int lineNum = 0;
		
		while((line = reader.readLine()) != null) {
			text = text + line + "\n";
			lineNum++;
		}
		
		reader.close();
		
//		text = IdlNvr.toHtmlText(text);
		
		out.println("<form method=post action=\"./manager\">");
		out.println("<input type=\"hidden\" name=\"cmd\" value=\"setUsageText\">");
		out.println("<textarea name=\"usageText\" cols=80 rows=40>" + text + "</textarea><br><br>");
		out.println("<input type=\"submit\" value=\"XV\">");
		out.println("</form>");
	}

	private void setUsageText(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		String rootDir = request.getSession().getServletContext().getInitParameter("RootDir");
		String fileName = rootDir + "usage.html";

		String usageText = request.getParameter("usageText");
		
		BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(fileName));
		writer.write(usageText.getBytes("MS932"));
		writer.close();
		
		out.println("done");
	}

	private void changeUserName(PrintWriter out, HttpServletRequest request, HttpServletResponse response, Database db) throws Exception {
		int userId = IdlNvr.getInt(request.getParameter("userid"));
		String userName = request.getParameter("userName");

		db.changeUserName(userId, userName);
		
		out.println("done");
	}
}
