/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.util.*;

import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class MemoResultServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_EDITOR;
	}

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String personName = request.getParameter("id");
		String country = request.getParameter("c");

		Person person = db.getPerson(personName, country);

		if(!person.freeEdit && !user.name.equals(person.editorName)) {
			out.println("ID̕ҏW҂ł͂܂<br>");
			return;
		}

		String memo =request.getParameter("memo");

		db.updateMemo(person.personId, memo);
		
		out.println("XV܂<br>");
		out.println("<br>");
		out.println("<a href=\"./detail?id=" + personName + "&c=" + country + "\">ڍ</a>");
		out.println(" <a href=\"./edit?id=" + personName + "&c=" + country + "\">ҏW</a>");

		out.println("<script>");
		out.println("<!--");
		out.println("location.href=\"./memo?id=" + personName + "&c=" + country + "\";");
		out.println("// -->");
		out.println("</script>");
	}
}
