/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class NewIdResultServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_EDITOR;
	}

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String id = request.getParameter("id");
		String country = request.getParameter("country");
		String detail =request.getParameter("detail");
		String visible = request.getParameter("visible");
		String aliasNamesText = request.getParameter("subid");
		String freeEdit = request.getParameter("freeedit");
		String showSubId = request.getParameter("showSubId");
		boolean validNames = true;
		
		if(aliasNamesText == null) aliasNamesText = "";
		StringTokenizer aliasTokens = new StringTokenizer(aliasNamesText, "\t\r\n @");
		Vector<String> aliasNames = new Vector<String>();
		
		while(aliasTokens.hasMoreTokens()) {
			String aliasName = aliasTokens.nextToken();
			if(!IdlNvr.checkPersonName(aliasName)) {
				out.println("sȃTuID: " + aliasName + "<br>");
				validNames = false;
			} else {
				aliasNames.addElement(aliasName);
			}
		}

		if(!IdlNvr.checkPersonName(id)) {
			out.println("sIDł");
			validNames = false;
		}
		
		if(validNames) {
			Person person = db.registerPerson(user.userId, id, country, detail, visible, aliasNames, freeEdit, showSubId);

			if(person == null) {
				out.println("ɓo^ς݂IDł");
			} else {
				db.clearPersonBoard(person.personId);
				
				Enumeration params = request.getParameterNames();
				int deleteCount = 0;

				while(params.hasMoreElements()) {
					String paramName = (String)params.nextElement();
					if(!paramName.startsWith("board_")) continue;
					if(!"on".equals(request.getParameter(paramName))) continue;

					String boardId = paramName.substring("board_".length());
					
					db.insertPersonBoard(person.personId, IdlNvr.getInt(boardId));
					
					deleteCount++;
				}

				out.println("o^܂<br>");
				out.println("<a href=\"./detail?id=" + person.name + "&c=" + person.country + "\">ڍ</a>");
				out.println(" <a href=\"./edit?id=" + person.name + "&c=" + person.country + "\">ҏW</a>");
			}
		}
	}
}
