/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class NewIdServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_EDITOR;
	}

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		out.println("VKID͂ĂB<br><br>");
		out.println("<form method=post action=\"./newidresult\">");
		out.println("IDF <input type=text name=id><br>");
		out.println("TuIDXgF<input type=text name=subid size=80><br>");

		out.println("TuIDXg̕\F <select name=\"showsubid\">");
		out.println("<option value=\"0\" selected>\Ȃ");
		out.println("<option value=\"1\">\");
		out.println("</select><br>");

		out.println("F <select name=\"country\">");
		out.println("<option value=\"1\">");
		out.println("<option value=\"2\">");
		out.println("</select><br>");

		out.println("J敪F <select name=\"visible\">");
		out.println("<option value=\"0\">J");
		out.println("<option value=\"1\" selected>J");
		out.println("</select><br>");

		out.println("̕ҏW҂ɂҏWF <select name=\"freeedit\">");
		out.println("<option value=\"0\" selected>Ȃ");
		out.println("<option value=\"1\">");
		out.println("</select><br><br>");

		out.println("ɊF");
		Vector<Board> boardList = db.getBoardList();

		out.println("<table border=0><tr>");
		for(int i=0; i<boardList.size(); i++) {
			Board board = boardList.elementAt(i);
			out.println("<td>" + board.boardId + ".<input type=checkbox name=\"board_" + board.boardId + "\" value=\"on\"> " + board.name + "</td>");
			if((i % 5) == 4) out.println("</tr><tr>");
		}
		out.println("</tr></table>");

		out.println("<br>");
		
		out.println("r[F<br>");
		out.println("<textarea name=\"detail\" cols=80 rows=20></textarea><br><br>");
		out.println("<input type=\"submit\" value=\"o^\">");
		out.println("</form>");
	}
}
