/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.w3c.dom.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class XmlServlet extends HttpServlet {
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGet(request, response);
	}

	private static String getCountryString(int country) {
		if(country == 1) return "Japan";
		else if(country == 2) return "Korea";
		else return "Unknown";
	}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
            request.setCharacterEncoding("Shift_JIS");
            response.setContentType("text/xml; charset=Shift_JIS");

			PrintWriter out = response.getWriter();
			String dbHost = request.getSession().getServletContext().getInitParameter("DBHost");

			Database db = new Database(dbHost);

			final Document doc = new DocumentImpl();
			
			final Element root = doc.createElement("IDList");
			
			PersonWalker walker;
			
			walker = new PersonWalker() {
				public void walk(Person person) throws Exception {
					if(!person.visible) return;
					
					Element personElem = doc.createElement("Person");
					personElem.setAttribute("Name", person.name);
					personElem.setAttribute("Country", getCountryString(person.country));
					
					Element contentElem = doc.createElement("Content");
					contentElem.setTextContent(person.html);
					
					personElem.appendChild(contentElem);
					
					for(int i=0; i<person.aliasNames.size(); i++) {
						String aliasName = person.aliasNames.elementAt(i);
						
						Element aliasElem = doc.createElement("Alias");
						aliasElem.setAttribute("Name", aliasName);
						
						personElem.appendChild(aliasElem);
					}
					
					root.appendChild(personElem);
				}
				
				public void init() {}
				public void exit() {}
			};
			
			db.walkPersons(-1, -1, walker, false);
			doc.appendChild(root);
			
			OutputFormat format = new OutputFormat(doc, "Shift_JIS", true);

			XMLSerializer serializer = new XMLSerializer(out, format);
			serializer.asDOMSerializer(); 
			serializer.serialize(doc.getDocumentElement());

			db.close();
			out.close();
		
		} catch(Exception e) {
			try {
				PrintWriter out = response.getWriter();
				e.printStackTrace(out);
				out.close();
			} catch(Exception e2) {
			}
		}
	}
}
