/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase;

import java.util.regex.*;
import com.enjoybase.model.*;
import com.enjoybase.conv.*;

public class Enjoybase {
	public static String VERSION = "0.13";

    private static Enjoybase instance = new Enjoybase();
  
    private Manifest manifest = null;
    
    private Enjoybase() {}

    public static Enjoybase getInstance() {
    	return instance;
    }

	public User login(String userName, String password) throws Exception {
		Storage db = null;

		try {
			db = new Storage();
	
			User user = db.getUser(userName, password);
	
			if(user == null) {
				throw new Exception("[U܂̓pX[hႢ܂B");
			}

			return user;
		} finally {
			try {
				db.close();
			} catch(Exception e) {}
		}
	}
	
	public Manifest getManifest() throws Exception {
		Manifest m = manifest;
		
		if(m != null) return m;

		synchronized(this) {
			if(manifest == null) {
				Storage db = new Storage();
				manifest = db.getLastManifest();
				db.close();
			}
		}

		return manifest;
	}

	public synchronized void updateManifest(int prevrev, String text, String editor) throws Exception {
		Manifest prev = manifest;

		if(prev.rev != prevrev) {
			throw new Exception(
					"ҏWɑ̕ҏW҂̃y[WXV܂B" +
					"ēxŐṼy[Wɑ΂ĕҏWsĂB");
		}

		Storage db = new Storage();
		ManifestConverter converter = new ManifestConverter(db, text, editor);
		converter.convert();

		manifest = db.storeManifest(converter.text, converter.html, editor);
		
		db.close();
	}

	public synchronized void updateTopic(int id, int prevrev, String text, String editor) throws Exception {
		Storage db = new Storage();

		try {
			Topic prevTopic = db.getTopic(id);
			
			if(prevTopic.rev != prevrev) {
				throw new Exception(
						"ҏWɑ̕ҏW҂̃y[WXV܂B" +
						"ēxŐṼy[Wɑ΂ĕҏWsĂB");
			}

			TopicConverter converter = new TopicConverter(db, text, editor);
			converter.convert();
	
			db.storeTopic(id, converter.text, converter.html, editor);

			db.close();
		} finally {
			if(db != null) db.close();
		}
	}

	public static String toHtmlText(String s) {
		if(s == null) return "";

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				case '\n': buf.append("<br>"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}

	public static String toArticleHtml(String s) {
		if(s == null) return "";

		s = s.replaceAll("\\\\s", " ");
		s = s.replaceAll("\\\\n", "\n");

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				case '\n': buf.append("<br>"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}


	public static String toHtmlTextArea(String s) {
		if(s == null) return "";

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}
	
	public static String toCountryHtml(String country) {
		if(country.equals("")) {
			return "<font color=\"red\"></font>";
		} else if(country.equals("")) {
			return "<font color=\"blue\"></font>";
		} else {
			return country;
		}
	}


	public static void checkPassword(String password) throws Exception {
		final Pattern pat = Pattern.compile("[a-zA-Z0-9]+");

		if(password == null || password.equals("")) throw new Exception("pX[hł");
		if(password.length() < 3 || password.length() > 15) throw new Exception("pX[h3~15w肵Ă");

		if(!pat.matcher(password).matches()) {
			throw new Exception("pX[h͉p݂̂w\ł");
		}
	}

	public static void checkUserName(String userName) throws Exception {
		final Pattern pat = Pattern.compile("[a-z0-9\\_]+");

		if(userName == null || userName.equals("")) throw new Exception("[Uł");
		if(userName.length() < 3 || userName.length() > 15) throw new Exception("pX[h3~15w肵Ă");

		if(!pat.matcher(userName).matches()) {
			throw new Exception("[U͉pEEA_[Ĉ݂w\ł");
		}
	}
}
