/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase;

import java.math.*;
import java.text.*;
import java.util.*;
import java.security.*;
import java.sql.*;
import com.enjoybase.model.*;
import com.enjoybase.conv.*;

/*
FDDL
create database enjoybase;
grant all privileges on enjoybase.* to enjoybase@localhost;


create table Users (
	UserID int(11) not null auto_increment primary key,
	UserName varchar(30) unique key,
	Password text,
	Random text,
	UserLevel int,
	RegisterDate datetime,
	LastLoginDate datetime);

create table Topics (
     ID int,
     Revision int,
     Text blob,
     HTML blob,
     Date datetime,
     Editor blob);

alter table Topics add index idx_rev(ID, Revision);
     
create table Manifest (
	Revision int NOT NULL auto_increment unique key, 
	Text blob, 
	HTML blob,
	Date datetime, 
	Editor blob);

create table Comments (
	CommentID int not null auto_increment primary key,
	TopicID int,
	CreateDate datetime,
	UserName varchar(30),
	Comment blob);

alter table Comments add index idx_topic(TopicID, CommentID);

create table History (
	HistoryID int not null auto_increment primary key,
	Date datetime,
	Editor varchar(30),
	Content blob);

 */

public class Storage {
	private static SimpleDateFormat datetimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static SQLSanitizer safer = new SQLSanitizer();
	private static Object editSync = new Object();
	public static boolean editlock = false;

	private Connection con;
	
	public Storage() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
		Class.forName("com.mysql.jdbc.Driver").newInstance();	

		con = DriverManager.getConnection(
//				"jdbc:mysql://192.168.3.2/enjoybase?useUnicode=true&characterEncoding=UTF-8",
				"jdbc:mysql://192.168.11.3/enjoybase?useUnicode=true&characterEncoding=UTF-8",
			"enjoybase",
			null);
	}
	public void close() throws SQLException {
		con.close();
	}

	public static void main(String args[]) {
		String userName = args[0];
		String password = args[1];
		
		byte randBytes[] = new byte[16];
		new Random().nextBytes(randBytes);
		String rand = new BigInteger(randBytes).abs().toString(16);
		
		System.out.println("rand: " + rand);
		System.out.println("auth: " + calcAuth(userName, password, rand));
	}
	
	private static String calcAuth(String userName, String password, String rand) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");

			md.update(userName.getBytes());
			md.update(password.getBytes());
			md.update(rand.getBytes());

			return new BigInteger(md.digest()).abs().toString(16);
		} catch(NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

	public void updateLastLoginDate(int userId) throws SQLException {
		Statement state = con.createStatement();
		
		state.executeUpdate("update Users set LastLoginDate=\"" + datetimeFormatter.format(new java.util.Date()) + "\" where UserID=" + userId);
		
		state.close();
	}

	public User getUser(String userName, String password) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where UserName=\"" + userName + "\"");
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		String destAuth = result.getString("Password");
		String rand = result.getString("Random");
		
		String srcAuth = calcAuth(userName, password, rand);
		
		if(!destAuth.equals(srcAuth)) {
			return null;
		}

		User user = new User(
			result.getInt("UserID"),
			result.getString("UserName"),
			result.getInt("UserLevel"));

		result.close();
		state.close();

		return user;
	}
	
	public User getUser(int userId) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where UserID=" + userId);
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		User user = new User(
				result.getInt("UserID"),
				result.getString("UserName"),
				result.getInt("UserLevel"));
		
		result.close();
		state.close();

		return user;
	}

	public String changePassword(int userId, String userName, String newPassword) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();

			byte randBytes[] = new byte[16];
			new Random().nextBytes(randBytes);
			String rand = new BigInteger(randBytes).abs().toString(16);
			
			String auth = calcAuth(userName, newPassword, rand);
			
			state.executeUpdate("update Users set Password= \"" + auth +  "\", Random=\"" + rand + "\" where UserID=" + userId);
	
			state.close();
			return null;
		}
	}

	public void deleteUser(int userId) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();
			state.executeUpdate("delete from Users where UserID="  + userId);
		}
	}

	public void walkUser(UserWalker walker) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet rs = state.executeQuery("select * from Users");
		
		while(rs.next()) {
			User user = new User(
					rs.getInt("UserID"),
					rs.getString("UserName"),
					rs.getInt("UserLevel"));

			if(!walker.walk(user)) break;
		}
		
		rs.close();
		state.close();
	}

	public String registerUser(String userName, String password) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();
		
			ResultSet result = state.executeQuery("select * from Users where UserName=\"" + userName + "\"");
			
			if(result.next()) {
				result.close();
				state.close();
				return "łɓo^Ă郆[Uł";
			}
			
			result.close();
	
			byte randBytes[] = new byte[16];
			new Random().nextBytes(randBytes);
			String rand = new BigInteger(randBytes).abs().toString(16);
			
			String auth = calcAuth(userName, password, rand);
			
			String regDate = datetimeFormatter.format(new java.util.Date());
			
			state.executeUpdate(
					"insert into Users values ("
					+ "null, "
					+ toSqlText(userName) + ", "
					+ toSqlText(auth) + ", " 
					+ toSqlText(rand) + ", "
					+ User.EDITOR + ", "
					+ toSqlText(regDate) + ", "
					+ toSqlText(regDate) + ")");
					
			state.close();
			return null;
		}
	}

	public Vector<User> getUsers() throws SQLException {
		Vector<User> users = new Vector<User>();
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users order by UserName");
		
		while(result.next()) {
			User user = new User(
					result.getInt("UserID"),
					result.getString("UserName"),
					result.getInt("UserLevel"));

			users.addElement(user);
		}
		
		result.close();
		state.close();

		return users;
	}

	public void updateUserLevel(int userId, int userLevel) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Users set UserLevel=" + userLevel +  " where UserID=" + userId);
		state.close();
	}

	private String toSqlText(String o) {
		if(o == null) return "null";

		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");

		return "\"" + s + "\"";
	}
	
	public Manifest getLastManifest() throws SQLException, ConverterException, ParseException {
		Statement state = con.createStatement();
		
		ResultSet rs = state.executeQuery("select * from Manifest order by Revision desc limit 0,1");

		if(!rs.next()) {
			return new Manifest();
		}

		Manifest manifest = new Manifest(
			rs.getInt("Revision"),
			rs.getString("Text"),
			rs.getString("HTML"),
			safer.sqlDatetimeToDate(rs.getString("Date")),
			rs.getString("Editor"));

		rs.close();
		state.close();

		return manifest;
	}
	
	public Manifest storeManifest(String text, String html, String editor) throws SQLException, ConverterException, ParseException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			
			Statement state = con.createStatement();
			String sql = "insert into Manifest values(null, " 
				+ safer.text(text) 
				+ ", " + safer.text(html)
				+ ", " + safer.datetime(new java.util.Date())
				+ ", " + safer.text(editor)
				+ ")";
			System.out.println(sql);
			state.executeUpdate(sql);

			Manifest manifest = getLastManifest();

//			state.executeUpdate("delete from Manifest where Revision <=" + (manifest.rev - 10));

			addHistory(editor, "gbvy[WXV");
			
			state.close();
			
			return manifest;
		}
	}

	public Topic createNewTopic(String editor) throws SQLException, ParseException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");

			Statement state = con.createStatement();
	
			ResultSet rs = state.executeQuery("select max(ID) from Topics");
			rs.next();
			int newid = rs.getInt(1) + 1;
			rs.close();

			state.executeUpdate("insert into Topics values("
				+ newid + ", 0, \"\", \"\""
				+ "," + safer.datetime(new java.util.Date()) 
				+ "," + safer.text(editor) + ")");

			addHistory(editor, "<a href=\"./topic?id=" + newid + "\">topic:" + newid + "</a> VK");

			state.close();
			return getTopic(newid);
		}
	}

	public Topic getTopic(int id) throws SQLException, ParseException {
		Statement state = con.createStatement();

		ResultSet rs = state.executeQuery("select * from Topics where ID=" + id
				+ " order by ID, Revision desc limit 0,1");
		if(!rs.next()) throw new SQLException("݂ȂgsbNIDw肳܂");

		Topic topic = new Topic(
				rs.getInt("ID"),
				rs.getInt("Revision"),
				rs.getString("Text"),
				rs.getString("Html"),
				safer.sqlDatetimeToDate(rs.getString("Date")),
				rs.getString("Editor"));
	
		rs.close();
		state.close();
		
		return topic;
	}

	public void storeTopic(int id, String text, String html, String editor) throws SQLException, ConverterException, ParseException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");

			Statement state = con.createStatement();

			ResultSet rs = state.executeQuery("select max(Revision) from Topics where ID=" + id);
			rs.next();
			int prevrev = rs.getInt(1);
			rs.close();
			
			int rev = prevrev + 1;

			state.executeUpdate("insert into Topics values(" + id 
				+ ", " + rev + ", " + safer.text(text) + ", " + safer.text(html)
				+ "," + safer.datetime(new java.util.Date()) 
				+ "," + safer.text(editor) + ")");

//			state.executeUpdate("delete from Topics where ID=" + id + " and Revision <= " + (rev-10));
			addHistory(editor, "<a href=\"./topic?id=" + id + "\">topic:" + id + "</a> XV");

			state.close();
		}
	}

	public boolean walkComments(int topicId, int page, CommentWalker walker) throws SQLException, ParseException {
		Statement state = con.createStatement();
		ResultSet rs;
		boolean hasNext = false;
		String order;
		
		String where = "";

		if(topicId != -1) {
			where = " where TopicID=" + topicId + " ";
			order = "desc";
		} else {
			order = "asc";
		}

		rs = state.executeQuery(
				"select * from Comments "+ where + " order by CommentID " + order
				+ " limit " + (page * 50) + ",51");

		int count = 0;
		Vector<Comment> comments = new Vector<Comment>();
		
		while(rs.next()) {
			count++;
			
			if(count == 50) {
				hasNext = true;
				break;
			}
			
			comments.addElement(new Comment(
					rs.getInt("TopicID"), 
					rs.getInt("CommentID"),
					rs.getString("UserName"),
					safer.sqlDatetimeToDate(rs.getString("CreateDate")),
					rs.getString("Comment")));
		}

		Collections.reverse(comments);
		
		for(Comment comment: comments) {
			if(!walker.walk(comment)) break;
		}

		state.close();
		return hasNext;
	}
	
	public void postComment(int topicId, String userName, String text) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");

			Statement state = con.createStatement();

			String sql = "insert into Comments values("
				+ "null"
				+ ", " + topicId
				+ ", " + safer.datetime(new java.util.Date())
				+ ", " + safer.text(userName)
				+ ", " + safer.text(text)
				+ ")";
	
			state.executeUpdate(sql);
			
			state.close();
		}
	}

	public void deleteComment(String userName, int commentId) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");

			Statement state = con.createStatement();
			
			String sql = "delete from Comments where CommentID="
				+ commentId + " and UserName=" + safer.text(userName);

			state.executeUpdate(sql);
			
			state.close();
		}
	}

	private void addHistory(String editor, String explain) throws SQLException {
		if(editlock) throw new SQLException("ҏWbNB");

		Statement state = con.createStatement();
		
		ResultSet rs = state.executeQuery("select Content from History order by HistoryID desc limit 0,1");
		
		String prev = null;
		
		if(rs.next()) {
			prev = rs.getString(1);
		}

		rs.close();
		
		if(prev == null || !explain.equals(prev)) {
			String sql = "insert into History values("
				+ "null"
				+ ", " + safer.datetime(new java.util.Date())
				+ ", " + safer.text(editor)
				+ ", " + safer.text(explain)
				+ ")";
	
			state.executeUpdate(sql);
		}

		state.close();
	}

	public void walkHistory(HistoryWalker walker) throws SQLException, ParseException {
		Statement state = con.createStatement();

		ResultSet rs = state.executeQuery(
				"select * from History order by HistoryID desc limit 0, 50");

		while(rs.next()) {
			java.util.Date date = safer.sqlDatetimeToDate(rs.getString(2));
			String editor = rs.getString(3);
			String explain = rs.getString(4);
			if(!walker.walk(date, editor, explain)) break;
		}

		rs.close();
		state.close();
	}

	public static void toggleEditLock() {
		synchronized(editSync) {
			editlock = !editlock;
		}
	}
	
	public void defrag(String strids, Vector<Integer> intids) throws SQLException, ParseException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");

			Statement state = con.createStatement();
			state.executeUpdate("delete from Topics where not ID in (" + strids + ")");
			
			for(int topicId: intids) {
				Topic topic = getTopic(topicId);
				state.executeUpdate("delete from Topics where ID=" + topic.id + " and Revision !=" + topic.rev);
			}

			ResultSet rs = state.executeQuery("select max(Revision) from Manifest");
			rs.next();
			int mrev = rs.getInt(1);
			rs.close();
			
			state.executeUpdate("delete from Manifest where Revision != " + mrev);
			
			state.close();
		}
	}
}
