/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.enjoybase.*;
import com.enjoybase.servlet.command.*;

public class CommandServlet extends HttpServlet {
	private static HashMap<String, Command> commands = new HashMap<String, Command>();

	private static void putCommand(Command command) {
		commands.put(command.getName(), command);
	}

	static {
		putCommand(new LoginCommand());
		putCommand(new LoginResultCommand());
		putCommand(new LogoutCommand());
		putCommand(new EditManifestResultCommand());
		putCommand(new EditTopicResultCommand());
		putCommand(new DeleteCommentCommand());
		putCommand(new PostCommentCommand());
		putCommand(new EditUsageCommand());
		putCommand(new RegisterUserCommand());
		putCommand(new ChangePasswordCommand());
		putCommand(new ToggleEditLockCommand());
		putCommand(new DeleteUserCommand());
		putCommand(new ImpersonateUserCommand());
		putCommand(new DefragCommand());
	}
	
	public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response);
	}

	public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response);
	}
	
	private void doGetOrPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");

			PrintWriter out = response.getWriter();
			
			out.println("<html><head>");
			out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
			out.println("<title>Enjoyc_f[^x[Xivg^CvŁj</title>");
			outStyleSheet(out);
			out.println("</head><body>");

			Enjoybase base = Enjoybase.getInstance();

			String cmd = request.getParameter("cmdid");

			Command command = commands.get(cmd);
			
			if(command == null) {
				out.println("invalid command");
			} else {
				command.exec(base, out, request, response);
			}

			out.println("</body></html>");
			
			out.close();

		} catch(Exception e) {
			try {
				PrintWriter out = response.getWriter();
				out.println("<pre>");
				e.printStackTrace(out);
				out.println("</pre>");
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	protected void outStyleSheet(PrintWriter out) throws IOException {
		out.println("  <style type=\"text/css\"><!-- ");
//		out.println("     * { font-size:8pt; }");
		out.println("  --></style>");
	}
}
