/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet.command;

import java.io.*;
import javax.servlet.http.*;
import com.enjoybase.*;

public class RegisterUserCommand extends Command {
	public RegisterUserCommand() {}

	public String getName() {
		return "registeruser";
	}

	public void exec(Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage db = null;
		
		try {
			HttpSession session = request.getSession(true);
			User user = (User)session.getAttribute("user");
	
			if(user == null) {
				user = User.getGuest();
				session.setAttribute("user", user);
			}
	
			if(!user.isEditor()) {
				out.println("OCĂ܂B");
				return;
			}
	
			String userName = request.getParameter("userid");
			String password = request.getParameter("password");
			String password2 = request.getParameter("password2");
			
			db = new Storage();

			Enjoybase.checkPassword(password);
			Enjoybase.checkUserName(userName);
		
			String errmsg = null;
			
			if(!password.equals(password2)) throw new Exception("pX[hvĂ܂"); 
					
			errmsg = db.registerUser(userName, password);
			if(errmsg != null) throw new Exception(errmsg);
	
			out.println("o^܂<br>");
			out.println("<br>");
		} catch(Exception e) {
			out.println(e.getMessage());
		} finally {
			db.close();
		}
	}
}
