/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver;

import java.io.*;
import java.util.*;
import java.text.*;

/**
 * Oo̓NX
 */
public class Log {
	private static SimpleDateFormat formatter = new SimpleDateFormat("MM/dd HH:mm:ss");
	private static Vector<PrintWriter> outs = new Vector<PrintWriter>(); // Oo͐PrintWriterꗗ
	
	/** CX^X֎~ */
	private Log() {}
	
	/**
	 * Oo͐t@CB̃tB[hnull̏ꍇAO͏o͂ȂB
	 */
	public static String logFileName = null;
	
	/**
	 * Oo͐ǉB
	 * @param writer
	 */
	public static void addOutput(PrintWriter writer) {
		outs.addElement(writer);
	}
	
	/**
	 * Oo͐폜B
	 * @param writer
	 */
	public static void removeOutput(PrintWriter writer) {
		outs.removeElement(writer);
	}
	
	/**
	 * 񃌃xȌóB
	 * @param s
	 */
	public static void info(String s) {
		String time = formatter.format(new Date());

		// Ot@Cւ̏o
		if(logFileName != null) {
			try {
				PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(logFileName, true)));
				writer.print(time + " ");
				writer.println(s);
				writer.close();
			} catch(Exception e) {
			}
		}
		
		// ǉOo͐ւ̏o
		for(int i=0; i<outs.size(); i++) {
			PrintWriter writer = (PrintWriter)outs.elementAt(i);
			writer.print(time + " ");
			writer.println(s);
		}
	}
	
	/**
	 * G[xȌo
	 * @param s
	 */
	public static void err(String s) {
		info(s);
	}

	/**
	 * G[xȌo
	 * @param e
	 */
	public static void err(Exception e) {
		String time = formatter.format(new Date());

		if(logFileName != null) {
			try {
				PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(logFileName, true)));
				writer.print(time + " ");
				e.printStackTrace(writer);
				writer.close();
			} catch(Exception e2) {
			}
		}

		for(int i=0; i<outs.size(); i++) {
			PrintWriter writer = (PrintWriter)outs.elementAt(i);
			writer.print(time + " ");
			e.printStackTrace(writer);
		}
	}
}
