/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.model;

import java.util.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.conv.*;
import com.aibonware.inaver.task.*;

public class UserConfig implements HttpSessionBindingListener {
	public static final int BOARD_THREAD_ID_AUTO = 0;
	public static final int BOARD_THREAD_ID_DISPID = 1;
	public static final int BOARD_THREAD_ID_NID = 2;

	public static final int BOARD_THREAD_CREATEDATE_MMDD = 0;
	public static final int BOARD_THREAD_CREATEDATE_MMDDMMSS = 1;
	
	
	//	Flags1
	public static final long ENABLE_FAST_LOGIN  = 0x0000000000000001L;
	public static final long ENABLE_THREAD_FLOW = 0x0000000000000002L;
	public static final long SHOW_ALL_CONTENTS  = 0x0000000000000004L;

	public static final long INDEX_SHOW_SEARCH = 0x0000000000000010L;

	public static final long BOARD_HEADER_SHOW_INDEX  = 0x0000000000000020L;
	public static final long BOARD_HEADER_SHOW_PREV   = 0x0000000000000040L;
	public static final long BOARD_HEADER_SHOW_NEXT   = 0x0000000000000080L;
	public static final long BOARD_HEADER_SHOW_LOGIO  = 0x0000000000000100L;
	public static final long BOARD_HEADER_SHOW_CONFIG = 0x0000000000000200L;
	public static final long BOARD_HEADER_SHOW_SEARCH = 0x0000000000000400L;

	public static final long BOARD_FOOTER_SHOW_INDEX  = 0x0000000000000800L;
	public static final long BOARD_FOOTER_SHOW_PREV   = 0x0000000000001000L;
	public static final long BOARD_FOOTER_SHOW_NEXT   = 0x0000000000002000L;
	public static final long BOARD_FOOTER_SHOW_LOGIO  = 0x0000000000004000L;
	public static final long BOARD_FOOTER_SHOW_CONFIG = 0x0000000000008000L;
	public static final long BOARD_FOOTER_SHOW_SEARCH = 0x0000000000010000L;

	public static final long BOARD_THREAD_SHOW_MAIL    = 0x0000000000800000L;

	public static final long THREAD_HEADER_SHOW_INDEX     = 0x0000000001000000L;
	public static final long THREAD_HEADER_SHOW_BOARD     = 0x0000000002000000L;
	public static final long THREAD_HEADER_SHOW_PREV      = 0x0000000004000000L;
	public static final long THREAD_HEADER_SHOW_NEXT      = 0x0000000008000000L;
	public static final long THREAD_HEADER_SHOW_DOWN      = 0x0000000010000000L;
	public static final long THREAD_HEADER_SHOW_CONFIG    = 0x0000000020000000L;
	public static final long THREAD_HEADER_SHOW_LOGIO     = 0x0000000040000000L;
	public static final long THREAD_HEADER_SHOW_NAVER_URL = 0x0000000000000008L;

	// Flags2
	public static final long THREAD_HEADER_SHOW_SEARCH    = 0x0000000100000000L;

	public static final long THREAD_FOOTER_SHOW_INDEX     = 0x0000000200000000L;
	public static final long THREAD_FOOTER_SHOW_BOARD     = 0x0000000400000000L;
	public static final long THREAD_FOOTER_SHOW_PREV      = 0x0000000800000000L;
	public static final long THREAD_FOOTER_SHOW_NEXT      = 0x0000001000000000L;
	public static final long THREAD_FOOTER_SHOW_UP        = 0x0000002000000000L;
	public static final long THREAD_FOOTER_SHOW_LOGIO     = 0x0000004000000000L;
	public static final long THREAD_FOOTER_SHOW_CONFIG    = 0x0000008000000000L;
	public static final long THREAD_FOOTER_SHOW_NAVER_URL = 0x0000010000000000L;
	public static final long THREAD_FOOTER_SHOW_SEARCH    = 0x0000020000000000L;
	public static final long THREAD_FOOTER_SHOW_UPDATE    = 0x0000040000000000L;
    
	public static final long ENABLE_NAVER_LOGIN           = 0x0000100000000000L;
	public static final long ENCRYPT_BY_LOGIN_PASSWORD    = 0x0000200000000000L;

	public final boolean isGuest;
	public final int userId;
	public final String userName;
	public final Date registerDate;
	public final Vector<String> filterThreadPosters = new Vector<String>();
	public final Vector<String> filterArticlePosters = new Vector<String>();
	public final int pageThreadNum;
	public final int pageArticleNum;
	public final int fastLinkSeed;
	public final long flags;
	public final String fastLoginAuth;
    public final int converterType;
	public final Date lastLoginDate;
	
	/** ŐVڽŕ\ۂ̍ŏڽ */
	public final int minThreadNum;

	/**
	 * rbg0̂ƂɗLrbg𔽓]
	 */
	public static long reverseNegativeBits(long src) {
		final long negativeMask = 
			  BOARD_HEADER_SHOW_LOGIO
			| BOARD_FOOTER_SHOW_NEXT
			| THREAD_HEADER_SHOW_BOARD
			| THREAD_HEADER_SHOW_DOWN
			| THREAD_HEADER_SHOW_LOGIO
			| THREAD_FOOTER_SHOW_BOARD
			| THREAD_FOOTER_SHOW_UP
			| THREAD_HEADER_SHOW_NEXT
			| THREAD_FOOTER_SHOW_NEXT
			| ENCRYPT_BY_LOGIN_PASSWORD;
			
		return src ^ negativeMask;
	}

	private static final UserConfig guestUserConfig = new UserConfig();
	
	public static UserConfig getGuest() {
		return guestUserConfig;
	}

	public UserConfig() {
		this(true, -1, "guest", new Date(), 0, 10, 10, 0, reverseNegativeBits(0), "", ContentsConverter.CONVERTER_TYPE_DEFAULT, new Date());
	}

	public UserConfig(
		int userId, 
		String userName, 
		Date registerDate,
		int minThreadNum,
		int pageThreadNum,
		int pageArticleNum,
		int fastLinkSeed,
		long flags,
		String fastLoginAuth,
        int converterType,
        Date lastLoginDate) {
			this(
				false, 
				userId, 
				userName, 
				registerDate, 
				minThreadNum, 
				pageThreadNum, 
				pageArticleNum, 
				fastLinkSeed, 
				flags, 
				fastLoginAuth, 
				converterType,
				lastLoginDate);
	}
	
	public UserConfig(
		boolean isGuest,
		int userId, 
		String userName, 
		Date registerDate,
		int minThreadNum,
		int pageThreadNum,
		int pageArticleNum,
		int fastLinkSeed,
		long flags,
		String fastLoginAuth,
        int converterType,
        Date lastLoginDate) {

			this.isGuest = isGuest;
			this.userId = userId;
			this.userName = userName;
			this.registerDate = registerDate;
			this.minThreadNum = minThreadNum;
			this.pageThreadNum = pageThreadNum;
			this.pageArticleNum = pageArticleNum;
			this.fastLinkSeed = fastLinkSeed;
			this.flags = flags;
			this.fastLoginAuth= fastLoginAuth;
            this.converterType = converterType;
			this.lastLoginDate = lastLoginDate;
	}
	
	public void addFilterThreadPoster(String poster) {
		filterThreadPosters.addElement(poster);
	}
	
	public String getFilterThreadPoster(int index) {
		return (String)filterThreadPosters.elementAt(index);
	}
	
	public int getFilterThreadPostersNum() {
		return filterThreadPosters.size();
	}

	public void addFilterArticlePoster(String poster) {
//		if(poster.length() > 10) poster = poster.substring(0, 10);
		filterArticlePosters.addElement(poster);
	}
	
	public String getFilterArticlePoster(int index) {
		return (String)filterArticlePosters.elementAt(index);
	}
	
	public int getFilterArticlePostersNum() {
		return filterArticlePosters.size();
	}
	
	public String getFilterThreadPostersText() {
		String text = "";
		
		for(int i=0; i<filterThreadPosters.size(); i++) {
			text = text + getFilterThreadPoster(i) + " ";
		}
		
		return text;
	}

	public String getFilterArticlePostersText() {
		String text = "";
		
		for(int i=0; i<filterArticlePosters.size(); i++) {
			text = text + getFilterArticlePoster(i) + " ";
		}
		
		return text;
	}
		
	public void setFilterThreadPostersText(String s) {
		filterThreadPosters.clear();
		StringTokenizer tokens = new StringTokenizer(s, " ");
		
		while(tokens.hasMoreTokens()) {
			String token = tokens.nextToken();
		
			addFilterThreadPoster(token);
		}
	}

	public void setFilterArticlePostersText(String s) {
		filterArticlePosters.clear();
		StringTokenizer tokens = new StringTokenizer(s, " ");
		
		while(tokens.hasMoreTokens()) {
			String token = tokens.nextToken();
		
			addFilterArticlePoster(token);
		}
	}

	public boolean fastLoginEnabled() {
		return (flags & ENABLE_FAST_LOGIN) != 0;
	}

	public boolean threadFlowEnabled() {
		return (flags & ENABLE_THREAD_FLOW) != 0;
	}

	public boolean showAllContents() {
		return (flags & SHOW_ALL_CONTENTS) != 0;
	}

	public boolean showNaverUrl() {
		return (flags & THREAD_HEADER_SHOW_NAVER_URL) != 0;
	}
	
	public boolean naverLoginEnabled() {
		return (flags & ENABLE_NAVER_LOGIN) != 0;
	}

	public boolean encryptByLoginPassword() {
		return (flags & ENCRYPT_BY_LOGIN_PASSWORD) != 0;
	}

	public synchronized void valueBound(HttpSessionBindingEvent event) {
		INaver inaver = INaver.getInstance();
		if(inaver != null) inaver.loginUserCount++;
	}
		
	public synchronized void valueUnbound(HttpSessionBindingEvent event) {
		INaver inaver = INaver.getInstance();
		if(inaver != null) inaver.loginUserCount--;
	}
	
	private Vector<UserTask> taskList = new Vector<UserTask>();

	public Vector<UserTask> getTaskList() {
		return taskList;
	}
}
