/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.aibonware.inaver.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.conv.*;
import com.aibonware.inaver.url.*;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
@SuppressWarnings("serial")
public class ConfigServlet extends HttpServlet {
	public ConfigServlet() {}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, true);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, false);
	}

	private void doGetOrPost(HttpServletRequest request, HttpServletResponse response, boolean isFirst) {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			UserConfig user = null;
			HttpSession session = request.getSession(false);

			if(session != null) user = (UserConfig)session.getAttribute("userconfig");

			if(user == null) {
				out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
				out.println("<title>ݒ</title></head><body>");

				out.println("OCĂ܂B");
				out.println("</body></html>");
			} else {
				SQLStoreProvider storeProvider = inaver.getStoreProvider();
				MasterStore store = storeProvider.openMasterStore();

				ConfigContext ct = new ConfigContext(
					request, 
					response,
					store,
					inaver,
					out,
					user);

				dispContents(ct, user, isFirst);

				store.close();
			}

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	protected int tonum(String s) {
		try {
			return Integer.parseInt(s);
		} catch(Exception e) {
			return -1;
		}
	}

	protected boolean checkToBool(String s) {
		if(s == null) return false;
		return s.equals("on");
	}

	private static class ConfigItem {
		public final String itemName;
		public final long bitmask;
		public final String explain;
		
		public ConfigItem(String itemName, long bitmask, String explain) {
			this.itemName = itemName;
			this.bitmask = bitmask;
			this.explain = explain;
		}
	}

	private static final ConfigItem[] indexItems = new ConfigItem[] {
		new ConfigItem("INDEX_SHOW_SEARCH", UserConfig.INDEX_SHOW_SEARCH, ""),		
	};
	
	private static final ConfigItem[] boardHeaderItems = new ConfigItem[] {
		new ConfigItem("BOARD_HEADER_SHOW_INDEX", UserConfig.BOARD_HEADER_SHOW_INDEX, ""),
		new ConfigItem("BOARD_HEADER_SHOW_PREV", UserConfig.BOARD_HEADER_SHOW_PREV, "O"),
		new ConfigItem("BOARD_HEADER_SHOW_NEXT", UserConfig.BOARD_HEADER_SHOW_NEXT, ""),
		new ConfigItem("BOARD_HEADER_SHOW_LOGIO", UserConfig.BOARD_HEADER_SHOW_LOGIO, "OAEg"),
		new ConfigItem("BOARD_HEADER_SHOW_CONFIG", UserConfig.BOARD_HEADER_SHOW_CONFIG, "[Uݒ"),
		new ConfigItem("BOARD_HEADER_SHOW_SEARCH", UserConfig.BOARD_HEADER_SHOW_SEARCH, ""),
	};

	private static final ConfigItem[] boardFooterItems = new ConfigItem[] {
		new ConfigItem("BOARD_FOOTER_SHOW_INDEX", UserConfig.BOARD_FOOTER_SHOW_INDEX, ""),
		new ConfigItem("BOARD_FOOTER_SHOW_PREV", UserConfig.BOARD_FOOTER_SHOW_PREV, "O"),
		new ConfigItem("BOARD_FOOTER_SHOW_NEXT", UserConfig.BOARD_FOOTER_SHOW_NEXT, ""),
		new ConfigItem("BOARD_FOOTER_SHOW_LOGIO", UserConfig.BOARD_FOOTER_SHOW_LOGIO, "OAEg"),
		new ConfigItem("BOARD_FOOTER_SHOW_CONFIG", UserConfig.BOARD_FOOTER_SHOW_CONFIG, "[Uݒ"),
		new ConfigItem("BOARD_FOOTER_SHOW_SEARCH", UserConfig.BOARD_FOOTER_SHOW_SEARCH, ""),
	};

	private static final ConfigItem[] boardThreadItems = new ConfigItem[] {
		new ConfigItem("BOARD_THREAD_SHOW_MAIL", UserConfig.BOARD_THREAD_SHOW_MAIL, "["),
	};

	private static final ConfigItem[] threadHeaderItems = new ConfigItem[] {
		new ConfigItem("THREAD_HEADER_SHOW_INDEX", UserConfig.THREAD_HEADER_SHOW_INDEX, ""),
		new ConfigItem("THREAD_HEADER_SHOW_BOARD", UserConfig.THREAD_HEADER_SHOW_BOARD, ""),
		new ConfigItem("THREAD_HEADER_SHOW_PREV", UserConfig.THREAD_HEADER_SHOW_PREV, "O"),
		new ConfigItem("THREAD_HEADER_SHOW_NEXT", UserConfig.THREAD_HEADER_SHOW_NEXT, ""),
		new ConfigItem("THREAD_HEADER_SHOW_DOWN", UserConfig.THREAD_HEADER_SHOW_DOWN, ""),
		new ConfigItem("THREAD_HEADER_SHOW_LOGIO", UserConfig.THREAD_HEADER_SHOW_LOGIO, "OAEg"),
		new ConfigItem("THREAD_HEADER_SHOW_CONFIG", UserConfig.THREAD_HEADER_SHOW_CONFIG, "[Uݒ"),
		new ConfigItem("THREAD_HEADER_SHOW_NAVER_URL", UserConfig.THREAD_HEADER_SHOW_NAVER_URL, "NAVERւ̃N"),
		new ConfigItem("THREAD_HEADER_SHOW_SEARCH", UserConfig.THREAD_HEADER_SHOW_SEARCH, ""),
	};

	private static final ConfigItem[] threadFooterItems = new ConfigItem[] {
		new ConfigItem("THREAD_FOOTER_SHOW_INDEX", UserConfig.THREAD_FOOTER_SHOW_INDEX, ""),
		new ConfigItem("THREAD_FOOTER_SHOW_BOARD", UserConfig.THREAD_FOOTER_SHOW_BOARD, ""),
		new ConfigItem("THREAD_FOOTER_SHOW_PREV", UserConfig.THREAD_FOOTER_SHOW_PREV, "O"),
		new ConfigItem("THREAD_FOOTER_SHOW_NEXT", UserConfig.THREAD_FOOTER_SHOW_NEXT, ""),
		new ConfigItem("THREAD_FOOTER_SHOW_UP", UserConfig.THREAD_FOOTER_SHOW_UP, ""),
		new ConfigItem("THREAD_FOOTER_SHOW_LOGIO", UserConfig.THREAD_FOOTER_SHOW_LOGIO, "OAEg"),
		new ConfigItem("THREAD_FOOTER_SHOW_CONFIG", UserConfig.THREAD_FOOTER_SHOW_CONFIG, "[Uݒ"),
		new ConfigItem("THREAD_FOOTER_SHOW_NAVER_URL", UserConfig.THREAD_FOOTER_SHOW_NAVER_URL, "NAVERւ̃N"),
		new ConfigItem("THREAD_FOOTER_SHOW_SEARCH", UserConfig.THREAD_FOOTER_SHOW_SEARCH, ""),
		new ConfigItem("THREAD_FOOTER_SHOW_UPDATE", UserConfig.THREAD_FOOTER_SHOW_UPDATE, "XV"),
	};

	private long updateFlags(long flags, HttpServletRequest request, ConfigItem items[]) {
		for(int i=0; i<items.length; i++) {
			if(checkToBool(request.getParameter(items[i].itemName))) flags |= items[i].bitmask;
		}
		
		return flags;
	}

	private static final SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
	
	private void dispContents(ConfigContext ct, UserConfig user, boolean isFirst) throws StoreException {
		PrintWriter out = ct.out;
		HttpServletRequest request = ct.request;
		MasterStore store = ct.store;

		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>ݒ</title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

        Log.info(user.userName + " config");

        out.println("O񃍃OCF" + df.format(user.lastLoginDate) + "<br>");
        
		if(!isFirst) {
			long flags = 0;

			if(checkToBool(request.getParameter("FastLogin"))) flags |= UserConfig.ENABLE_FAST_LOGIN;
			if(checkToBool(request.getParameter("ThreadFlow"))) flags |= UserConfig.ENABLE_THREAD_FLOW;
			if(checkToBool(request.getParameter("ShowAll"))) flags |= UserConfig.SHOW_ALL_CONTENTS;

			flags = updateFlags(flags, request, indexItems);
			flags = updateFlags(flags, request, boardHeaderItems);
			flags = updateFlags(flags, request, boardFooterItems);
			flags = updateFlags(flags, request, boardThreadItems);
			flags = updateFlags(flags, request, threadHeaderItems);
			flags = updateFlags(flags, request, threadFooterItems);

			int minThreadNum = tonum(request.getParameter("MinThreadNum"));
			int pageThreadNum = tonum(request.getParameter("PageThreadNum"));
			int pageArticleNum = tonum(request.getParameter("PageArticleNum"));
            int converterType = tonum(request.getParameter("ConverterType"));
	
			UserConfig newUser = new UserConfig(
				user.userId,
				user.userName,
				user.registerDate,
				minThreadNum,
				pageThreadNum,
				pageArticleNum,
				user.fastLinkSeed,
				flags,
				user.fastLoginAuth,
                converterType,
                new Date());

			newUser.setFilterThreadPostersText(request.getParameter("FilterThreadPosters"));			
			newUser.setFilterArticlePostersText(request.getParameter("FilterArticlePosters"));			

			store.updateUser(newUser);
			
			user = newUser;
			HttpSession session = request.getSession(false);
			session.setAttribute("userconfig", user);

			out.println("ݒ芮B<br>");
		}

		out.println("<form method=post action=\"" + ct.createCurrentUrl() + "\">");

		out.println("S<br>");
		out.print("@<input type=checkbox name=\"FastLogin\" value=\"on\"" + (user.fastLoginEnabled() ? "checked" : "") + ">");
		out.println("ȈՃOCLɂB<br>");
		if(user.fastLoginEnabled()) {
			out.print("@@(<a href=\"fastlogin?auth=" + user.fastLoginAuth + "\">ȈՃOCւ̃N</a>)<br>");
		}

		out.println("<br>");
		out.println("tB^ݒ<br>");
		out.println("@̨گނ̓eҖ󔒂ŋ؂ē͂ĂB<br>");
		out.println("@<input type=textarea name=\"FilterThreadPosters\" value=\"" + user.getFilterThreadPostersText() + "\"><br>");
		out.println("@̨ڽ̓eҖ󔒂ŋ؂ē͂ĂB<br>");
		out.println("@<input type=textarea name=\"FilterArticlePosters\" value=\"" + user.getFilterArticlePostersText() +  "\"><br>");

		out.println("<br>");
		out.println("\ݒ<br>");
		out.print("@<input type=checkbox name=\"ThreadFlow\" value=\"on\"" + (user.threadFlowEnabled() ? "checked" : "") + ">");
//      out.println("ŐVگ<font color=\"red\">݋@\~I</font>(<input type=text name=MinThreadNum istyle=4 value=\"" + user.minThreadNum + "\">ȏڽꍇ)<br>");
        out.println("<input type=text name=MinThreadNum value=\"" + user.minThreadNum + "\">ȏڽڂ\<br>");

		out.println("<br>");
		out.println("\ݒ<br>");
		out.println("@گޕ\P<input type=text name=PageThreadNum value=\"" + user.pageThreadNum + "\">)<br>");
		out.println("@ڽ\P<input type=text name=PageArticleNum value=\"" + user.pageArticleNum + "\">)<br>");

		out.print("@<input type=checkbox name=\"ShowAll\" value=\"on\"" + (user.showAllContents() ? "checked" : "") + ">");
		out.println("گޓee߂S\<br>");

//		out.print("@<input type=checkbox name=\"ShowNaver\" value=\"on\"" + (user.showNaverUrl() ? "checked" : "") + ">");
//		out.println("NAVER̽گނւݸ\<br>");

		out.println("<br>");

        out.println("Contents Converter<font color=\"red\">(ύXȂŉ!)</font>F<select name=\"ConverterType\">");
        out.println("<option value=\"0\" " + (user.converterType == ContentsConverter.CONVERTER_TYPE_DEFAULT ? "selected" : "") + ">Default");
        out.println("<option value=\"1\" " + (user.converterType == ContentsConverter.CONVERTER_TYPE_NULL ? "selected" : "") + ">NullConverter");
        out.println("<option value=\"2\" " + (user.converterType == ContentsConverter.CONVERTER_TYPE_NEKO ? "selected" : "") + ">NekoConverter");
        out.println("</select><br>");
        out.println("<br>");

		out.println("\ڐݒ<br>");
		outItems(out, user.flags, "", indexItems);
		outItems(out, user.flags, "Xbhꗗwb_", boardHeaderItems);
		outItems(out, user.flags, "Xbhꗗtb^", boardFooterItems);
		outItems(out, user.flags, "Xbhꗗe", boardThreadItems);
		outItems(out, user.flags, "Xꗗwb_", threadHeaderItems);
		outItems(out, user.flags, "Xꗗtb^", threadFooterItems);

		out.println("<a href=\"" + new AuthUrl("naveraccount", request).toString(ct.response) + "\">NAVERAJEg̐ݒ</a><br>");
		out.println("<a href=\"" + new AuthUrl("changepassword", request).toString(ct.response) + "\">gуTCgppX[hύX</a><br>");
		out.println("<br>");

		out.println("<input type=submit value=\"ݒ\">");
		out.println("</form>");

		out.println("</body></html>");
	}
		
	private void outItems(PrintWriter out, long flags, String title, ConfigItem[] items) {
		out.println("" + title + "<br>");

		for(int i=0; i<items.length; i++) {
			out.print("@<input type=checkbox name=\"");
			out.print(items[i].itemName);
			out.print("\" value=\"on\"");
			if((flags & items[i].bitmask) != 0) out.print("checked");
			out.print(">");
			out.println(items[i].explain);
		}
		
		out.println("<br><br>");
	}
}

