/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
@SuppressWarnings("serial")
public class FastLoginServlet extends HttpServlet {
	private static Pattern pat = Pattern.compile("\\w+");

	public FastLoginServlet() {}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			SQLStoreProvider storeProvider = inaver.getStoreProvider();
			MasterStore store = storeProvider.openMasterStore();

			String auth = request.getParameter("auth");
			Matcher mat = pat.matcher(auth);

			if(auth == null || auth.equals("")) dispLoginFailed(out);
			else if(!mat.matches()) dispLoginFailed(out);
			else {
				UserConfig user = store.fastLoginUser(auth);
				if(user == null) {
                    Log.info("fast login failed");
					dispLoginFailed(out);
				} else {
                    Log.info(user.userName+ " fast login");
					HttpSession session = request.getSession(true);
					session.setAttribute("userconfig", user);
					session.setAttribute("naveraccount", store.queryNaverAccount(user.userId, null));
					
					dispLoginSucceeded(out, request, response, user, store, inaver);
				}
			}

			store.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}
	
	private void dispLoginFailed(PrintWriter out) {
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>ȈՃOC</title></head><body>");

		out.println("ȈՃOCɎs܂B");
		out.println("</body></html>");
	}

	private void dispLoginSucceeded (
	  PrintWriter out, 
	  HttpServletRequest request, 
	  HttpServletResponse response, 
	  UserConfig user,
	  MasterStore store,
	  INaver inaver) throws StoreException, IOException, ServletException {

		AuthServletContext ct = new AuthServletContext(
			user,
			request,
			response,
			store,
			inaver,
			out,
			new AuthUrl("index.html", 1));
			
		IndexContents.dispContents(ct);
	}
}
