/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.web.*;

/**
 * 
 */
@SuppressWarnings("serial")
public class ManagerServlet extends HttpServlet {
	private void doHello(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		out.println("Hello");
/*		
		try {
			SQLStore store = INaver.getInstance().getStoreProvider().openContentsStore();
			
			BoardList boards = store.queryBoardList(true, true);
			
			for(int i=0; i<boards.getBoardCount(); i++) {
				renewalBoard(store, boards.getBoard(i));
			}
			
			store.close();
			
		} catch(Exception e) {
			Log.err(e);
		}
*/		
	}
	
	private static SimpleDateFormat tf = new SimpleDateFormat("yy/MM/dd HH:mm");
	private static final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");

	public ManagerServlet() {}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		response.setContentType("text/html; charset=MS932");
		PrintWriter out = response.getWriter();
		
		out.println(
			"<html><head><meta http-equiv='Content-type' content='text/html; "
			+ "charset=Shift_JIS'><title>Manager</title></head><body>");

		try {
			String command = request.getParameter("command");
	
			if(command == null || command.equals("")) dispMain(out, request, response);
			else if(command.equals("hello")        ) doHello(     out, request, response);
			else if(command.equals("start_service")) startService(out, request, response);
			else if(command.equals("disp_env")     ) dispEnv(     out, request, response);
			else if(command.equals("edit_env")     ) editEnv(     out, request, response);
			else if(command.equals("start_crawl")  ) startMasterCrawl(  out, request, response);
			else if(command.equals("stop_crawl")   ) stopMasterCrawl(   out, request, response);
			else if(command.equals("start_backup") ) startBackup(  out, request, response);
			else if(command.equals("stop_backup")  ) stopBackup(   out, request, response);
			else if(command.equals("disp_user")    ) dispUsers(   out, request, response);
			else if(command.equals("disp_del_user")) dispDelUsers(out, request, response);
			else if(command.equals("delete_user")  ) deleteUsers (out, request, response);
			else if(command.equals("disp_delreq")  ) dispDelReq  (out, request, response);
			else if(command.equals("change_delreq")) changeDelReq(out, request, response);
			else if(command.equals("add_user"     )) addUser(out, request, response);

		} catch(Exception e) {
			out.println(e.getMessage());
			e.printStackTrace(out);
		}

		out.println("</body></html>");
		out.close();
	}

	private String getStrParam(HttpServletRequest request, String name) throws Exception {
		String s = request.getParameter(name);

		if(s == null || s.trim().equals("")) {
			throw new Exception("parameter " + name + " is empty.");
		}
	
		return s;
	}
    
    private int getIntParam(HttpServletRequest request, String name) throws Exception {
        String s = request.getParameter(name);

        if(s == null || s.trim().equals("")) {
            throw new Exception("parameter " + name + " is empty.");
        }
    
        return Integer.parseInt(s);
    }

	private void dispMain(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		// Hello
		out.println("<form action=\".\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"command\" value=\"hello\">");
		out.println("	<input type=\"submit\" value=\"Hello\">");
		out.println("</form>");
		
		// ϐݒ
		out.println("<form action=\".\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"command\" value=\"disp_env\">");
		out.println("	<input type=\"submit\" value=\"Env\">");
		out.println("</form>");
		
		// T[rXJn
		out.println("<form action=\".\" method=\"post\">");
		out.println("	<input type=\"hidden\" name=\"command\" value=\"start_service\">");
		out.println("	<input type=\"submit\" value=\"Start Service\">");
		out.println("   DbPass: <input type=\"text\" name=\"DbPass\">");
		out.println("</form>");
		
		INaver inaver  = INaver.getInstance();

		if(inaver != null) {
			// N[Jn
			if(!inaver.getMasterScheduler().nowStarted) {
				out.println("<form action=\".\" method=\"post\">");
				out.println("	<input type=\"hidden\" name=\"command\" value=\"start_crawl\">");
				out.println("	<input type=\"submit\" value=\"Start Crawler\">");
				out.println("</form>");
			}

			// N[~
			if(inaver.getMasterScheduler().nowStarted) {
				out.println("<form action=\".\" method=\"post\">");
				out.println("	<input type=\"hidden\" name=\"command\" value=\"stop_crawl\">");
				out.println("	<input type=\"submit\" value=\"Stop Crawler\">");
				out.println("</form>");
			}
			
			if(!inaver.getBackupScheduler().nowStarted) {
				out.println("<form action=\".\" method=\"post\">");
				out.println("	<input type=\"hidden\" name=\"command\" value=\"start_backup\">");
				out.println("	<input type=\"submit\" value=\"Start Backup\">");
				out.println("</form>");
			}

			if(inaver.getBackupScheduler().nowStarted) {
				out.println("<form action=\".\" method=\"post\">");
				out.println("	<input type=\"hidden\" name=\"command\" value=\"stop_backup\">");
				out.println("	<input type=\"submit\" value=\"Stop Backup\">");
				out.println("</form>");
			}

			// [UǗ
			out.println("<form action=\".\" method=\"post\">");
			out.println("	<input type=\"hidden\" name=\"command\" value=\"disp_user\">");
			out.println("	<input type=\"submit\" value=\"Users\">");
			out.println("</form>");

			// [Uǉ
			out.println("<form action=\".\" method=\"post\">");
			out.println("	<input type=\"hidden\" name=\"command\" value=\"add_user\">");
			out.println("	<input type=\"submit\" value=\"Add New User\">");
			out.println("   NewUserName: <input type=\"text\" name=\"NewUserName\">");
			out.println("</form>");
			
			// 폜\Ǘ
			out.println("<form action=\".\" method=\"post\">");
			out.println("	<input type=\"hidden\" name=\"command\" value=\"disp_delreq\">");
			out.println("	<input type=\"submit\" value=\"Delete Requests\">");
			out.println("</form>");
			
			MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();

			out.println("Login Users: " + inaver.loginUserCount + "<br>");
			out.println("Active Del Requets: " + sqlStore.getActiveDelRequestCount() + "<br>");
			out.println("Task Count: " + inaver.getTaskCount() + "<br>");
			
			sqlStore.close();
		}
	}

	private void startService(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		if(Log.logFileName == null) {
			Env env = Env.getEnv();
			Log.logFileName = env.rootDir + "inaver.log";
		}

		String dbPass = getStrParam(request, "DbPass");
		INaver.start(dbPass);
		out.println("service started.<br>");
		dispMain(out, request, response);
	}

	private void dispEnv(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		Env env = Env.getEnv();

		out.println("<form action=\".\" method=\"post\">");
		out.println("<input type=\"hidden\" name=\"command\" value=\"edit_env\">");
		out.println("  RootDir: <input type=\"text\" name=\"RootDir\" value=\"" + env.rootDir + "\"><br>");
        out.println("  ArticleListDir: <input type=\"text\" name=\"ArticleListDir\" value=\"" + env.rlistDir + "\"><br>");
        out.println("  RankingDir: <input type=\"text\" name=\"RankingDir\" value=\"" + env.rankDir + "\"><br>");
		out.println("  ServiceBaseUrl: <input type=\"text\" name=\"ServiceBaseUrl\" value=\"" + env.serviceBaseUrl + "\"><br>");
		out.println("  NaverBaseUrl: <input type=\"text\" name=\"NaverBaseUrl\" value=\"" + env.naverBaseUrl + "\"><br>");
		out.println("  DbHost: <input type=\"text\" name=\"DbHost\" value=\"" + env.dbHost + "\"><br>");
		out.println("  LastDailyWork: <input type=\"text\" name=\"LastDailyWork\" value=\"" + df.format(env.getLastDailyWork()) + "\"><br>");
        out.println("  Announcement: <input type=\"text\" name=\"Announcement\" value=\"" + env.announcement + "\"><br>");
        out.println("  TrafficLimit: <input type=\"text\" name=\"TrafficLimit\" value=\"" + env.trafficLimit + "\"><br>");
        out.println("  BuildNo: <input type=\"text\" name=\"BuildNo\" value=\"" + env.buildNo + "\"><br>");
        out.println("  Information: <input type=\"text\" name=\"Information\" value=\"" + env.information + "\"><br>");
        out.println("  SearchLimitTime: <input type=\"text\" name=\"SearchLimitTime\" value=\"" + env.searchLimitTime + "\"><br>");
        out.println("  NewArtNum: <input type=\"text\" name=\"NewArtNum\" value=\"" + env.newArtNum + "\"><br>");
        out.println("  UniqueLimit: <input type=\"text\" name=\"UniqueLimit\" value=\"" + env.uniqueLimit + "\"><br>");
        out.println("  MobileUserAgents: <input type=\"text\" name=\"MobileUserAgents\" value=\"" + env.getMobileUserAgentsText() + "\"><br>");

        out.println("  EnableUserConfig: <select name=\"EnableUserConfig\">");
        
        out.print  ("<option value=\"True\""); 
        if(env.enableUserConfig.equals("True")) out.print(" selected");
        out.println(">True");
        
        out.print  ("<option value=\"False\""); 
        if(!env.enableUserConfig.equals("True")) out.print(" selected");
        out.println(">False");
        
        out.println("  </select><br>");
        
        out.println("<input type=\"submit\" value=\"Update\">");
		out.println("</form>");
	}

    private String getMessageParam(HttpServletRequest request, String name) throws Exception {
        String value = request.getParameter(name);
        
        if(value == null || value.trim().equals("")) {
            value = "";
        } else {
            value = new String(value.getBytes("iso-8859-1"), "Shift_JIS");
        }
        
        return value;
    }
    
	private void editEnv(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		Env env = Env.getEnv();

		String rootDir = getStrParam(request, "RootDir");
		String serviceBaseUrl = getStrParam(request, "ServiceBaseUrl");
		String naverBaseUrl = getStrParam(request, "NaverBaseUrl");
		String dbHost = getStrParam(request, "DbHost");
		String sLastDailyWork = getStrParam(request, "LastDailyWork");
		Date lastDailyWork = df.parse(sLastDailyWork);
        String enableUserConfig = getStrParam(request, "EnableUserConfig");
        int trafficLimit = getIntParam(request, "TrafficLimit");

        String buildNo = getMessageParam(request, "BuildNo");
		String announcement = getMessageParam(request, "Announcement");
        String information = getMessageParam(request, "Information");
        int searchLimitTime = getIntParam(request, "SearchLimitTime");
        int newArtNum = getIntParam(request, "NewArtNum");
        int uniqueLimit = getIntParam(request, "UniqueLimit");
        String rlistDir = getMessageParam(request, "ArticleListDir");
        String rankDir = getMessageParam(request, "RankingDir");
        String mobileUserAgents = getMessageParam(request, "MobileUserAgents");

		env.rootDir = rootDir;
		env.serviceBaseUrl = serviceBaseUrl;
		env.naverBaseUrl = naverBaseUrl;
		env.dbHost = dbHost;
		env.announcement = announcement;
        env.enableUserConfig = enableUserConfig;
        env.trafficLimit = trafficLimit;
        env.buildNo = buildNo;
        env.information = information;
        env.searchLimitTime = searchLimitTime;
        env.newArtNum = newArtNum;
        env.uniqueLimit = uniqueLimit;
        env.rlistDir = rlistDir;
        env.rankDir = rankDir;
        env.setMobileUserAgentsText(mobileUserAgents);

		env.setLastDailyWork(lastDailyWork);
		env.flush();
		out.println("environment updated.<br>");
		dispEnv(out, request, response);
	}

	private void startMasterCrawl(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		if(INaver.getInstance().getMasterScheduler().nowStarted) {
			out.println("already started<br>");
			return;
		}
		
		INaver.getInstance().startMasterScheduler();

		out.println("crawler started.<br>");
		dispMain(out, request, response);
	}

	private void stopMasterCrawl(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		if(!INaver.getInstance().getMasterScheduler().nowStarted) {
			out.println("not started<br>");
			return;
		}
		
		INaver.getInstance().stopMasterScheduler();

		out.println("Crawler stopped.<br>");
		dispMain(out, request, response);
	}
	
	private void startBackup(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		if(INaver.getInstance().getBackupScheduler().nowStarted) {
			out.println("already started<br>");
			return;
		}
		
		INaver.getInstance().startBackupScheduler();

		out.println("backup started.<br>");
		dispMain(out, request, response);
	}

	private void stopBackup(PrintWriter out, HttpServletRequest request, HttpServletResponse response)  throws Exception {
		if(!INaver.getInstance().getBackupScheduler().nowStarted) {
			out.println("not started<br>");
			return;
		}
		
		INaver.getInstance().stopBackupScheduler();

		out.println("backup stopped.<br>");
		dispMain(out, request, response);
	}
	
	private void dispUsers(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		Vector<UserConfig> users = sqlStore.getUserList();
		
		out.println("<form action=\".\" method=\"post\">");
		out.println("<input type=\"hidden\" name=\"command\" value=\"disp_del_user\">");
		out.println("<table border=\"1\">");

		out.println("\t<tr>");
		outCol(out, "UserID");
		outCol(out, "userName");
		outCol(out, "RegisterDate");
		outCol(out, "LastLoginDate");
		out.println("\t</tr>");
		
		for(int i=0; i<users.size(); i++) {
			UserConfig user = users.elementAt(i);
			out.println("\t<tr>");

			outCol(out, "<input type=checkbox name=\"userid\" value=\"" + user.userId + "\">" + user.userId);
			outCol(out, user.userName);
			outCol(out, tf.format(user.registerDate));
			outCol(out, tf.format(user.lastLoginDate));

			out.println("\t</tr>");
		}

		out.println("</table>");
		out.println("<br><input type=\"submit\" value=\"Delete User\">");
		out.println("</form>");
		
		sqlStore.close();
	}
	
	private void dispDelUsers(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		String idsText[] = request.getParameterValues("userid");
		Vector<UserConfig> users = new Vector<UserConfig>();

		out.println("<font color=\"red\">delete user</font><br>");
		out.println("<form action=\".\" method=\"post\">");
		out.println("<input type=\"hidden\" name=\"command\" value=\"delete_user\">");

		out.print("<input type=\"hidden\" name=\"userid\" value=\"");
		
		for(int i=0; i<idsText.length; i++) out.print(idsText[i] + ",");
		
		out.println("\">");

		out.println("<table border=\"1\">");

		out.println("\t<tr>");
		outCol(out, "UserID");
		outCol(out, "userName");
		outCol(out, "RegisterDate");
		out.println("\t</tr>");

		for(int i=0; i<idsText.length; i++) {
			String token = idsText[i];
			int userId = Integer.parseInt(token);
			
			UserConfig user = sqlStore.getUser(userId);
			users.addElement(user);		

			out.println("\t<tr>");
			outCol(out, user.userId);
			outCol(out, user.userName);
			outCol(out, tf.format(user.registerDate));
			out.println("\t</tr>");
		}

		out.println("</table>");
		out.println("<br><input type=\"submit\" value=\"confirm\">");
		out.println("</form>");

		sqlStore.close();
	}
	
	private void addUser(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Pattern pat = Pattern.compile("\\w+");

		MasterStore store = INaver.getInstance().getStoreProvider().openMasterStore();
		String newUserName = getStrParam(request, "NewUserName");
		String passwordChars = "abcdefghijklmnopqrstuvwxyz123456789";
		String password = "";
		String result = "";
		
		for(int i=0; i<8; i++) {
			password = password + passwordChars.charAt(Math.abs(INaver.getInstance().getRand()) % passwordChars.length());
		}

		out.println("[UF" + newUserName + "<br>");
		out.println("pX[hF" + password + "<br>");
		
		if(newUserName.length() > 14) {
			result = result + "[U܂<br>";
		}

		Matcher mat = pat.matcher(newUserName);
		if(!mat.matches()) {
			result = result + "[Uɕsȕ܂܂Ă܂<br>";
		}

		if(result.equals("")) {
			result = result + store.registerUser(newUserName, password, INaver.getInstance().getRand());
		}

		out.println(result);
		
		store.close();
	}
	
	private void deleteUsers(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		StringTokenizer tokens = new StringTokenizer(request.getParameter("userid"), ",");
		int count = 0;

		while(tokens.hasMoreTokens()) {
			String token = tokens.nextToken();
			int userId = Integer.parseInt(token);
			
			sqlStore.deleteUser(userId);
			count++;
		}

		out.println("" + count + " users deleted.<br>");
		sqlStore.close();
	}

/*
	private void dispUser2(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		Vector<UserConfig> users = sqlStore.getUserList();
		
		out.println("<table border=\"1\">");

		out.println("\t<tr>");
		outCol(out, "UserID");
		outCol(out, "userName");
		outCol(out, "RegisterDate");
		outCol(out, "MinThreadNum");
		outCol(out, "PageThreadNum");
		outCol(out, "PageArticleNum");
		outCol(out, "FastLinkSeed");
		outCol(out, "Flags1");
		outCol(out, "FastLoginAuth");
		out.println("\t</tr>");
		
		for(int i=0; i<users.size(); i++) {
			UserConfig user = users.elementAt(i);
			out.println("\t<tr>");
			
			outCol(out, user.userId);
			outCol(out, user.userName);
			outCol(out, tf.format(user.registerDate));
			outCol(out, user.minThreadNum);
			outCol(out, user.pageThreadNum);
			outCol(out, user.pageArticleNum);
			outCol(out, Integer.toHexString(user.fastLinkSeed));
			outCol(out, Long.toHexString(user.flags));
			outCol(out, user.fastLoginAuth);
			
			out.println("\t</tr>");
		}
		
		out.println("</table>");
		sqlStore.close();
	}
*/
	
	private void outCol(PrintWriter out, int i) {
		out.println("\t\t<td>" + i + "</td>");
	}
	
	private void outCol(PrintWriter out, String text) {
		out.println("\t\t<td>" + text + "</td>");
	}

	private void dispDelReq(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		WebStore webStore = INaver.getInstance().getWebStore();

		out.println("<form action=\".\" method=\"post\">");
		out.println("<input type=\"hidden\" name=\"command\" value=\"change_delreq\">");

		Vector<DelRequest> delRequests = sqlStore.queryDelRequestList();

		out.println("<table border=\"1\">");

		out.println("\t<tr>");
		outCol(out, "ID");
		outCol(out, "Reason");
		outCol(out, "Board");
		outCol(out, "NID");
		outCol(out, "RequestDate");
		outCol(out, "ProcessDate");
		outCol(out, "URL");
		outCol(out, "NAVER");
		outCol(out, "Status");
		outCol(out, "Change");
		out.println("\t</tr>");

		for(int i=0; i<delRequests.size(); i++) {
			DelRequest req = delRequests.elementAt(i);

			out.println("\t<tr>");
			outCol(out, req.requestId);
			outCol(out, WebStore.text(req.reason));
			outCol(out, req.boardId);
			outCol(out, req.nid);
			outCol(out, tf.format(req.requestDate));
			outCol(out, req.processDate == null ? "null" : tf.format(req.processDate));
			outCol(out, "<a href=\"" + INaver.getInstance().serviceBaseUrl + "thread?b=" + req.boardId + "&id=" + req.nid + "&s=0&e=9\">*</a>");
			outCol(out, "<a href=\"" + webStore.getThreadUrlForLink(sqlStore.queryBoard(req.boardId), req.nid) + "\">*</a>");
			outCol(out, req.getStatusString());

			if(req.status == DelRequest.DELSTAT_ACCEPTED) {
				outCol(out, "@");
			} else {
				String s = "<select name=\"Change\">"
					+ "<option value=\"" + req.requestId + ",0\">"
					+ "<option value=\"" + req.requestId + ",1\">OPEN"
					+ "<option value=\"" + req.requestId + ",2\">ACCEPT"
					+ "<option value=\"" + req.requestId + ",3\">REJECT"
					+ "<option value=\"" + req.requestId + ",4\">ERROR"
					+ "</select>";

				outCol(out, s);
			}
			out.println("\t</tr>");
		}

		out.println("</table>");
		out.println("<br><input type=\"submit\" value=\"change\">");
		out.println("</form>");

		sqlStore.close();
	}

	private void changeDelReq(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		int reqCount = 0;
		int accCount = 0;

		MasterStore sqlStore = (MasterStore)INaver.getInstance().getStoreProvider().openMasterStore();
		String changeTexts[] = request.getParameterValues("Change");

		for(int i=0; i<changeTexts.length; i++) {
			StringTokenizer tokens = new StringTokenizer(changeTexts[i], ",");
			int requestId = Integer.parseInt(tokens.nextToken());	
			int newStatus = Integer.parseInt(tokens.nextToken());

			if(newStatus == 0) continue;
			reqCount++;
			
			if(newStatus != DelRequest.DELSTAT_ACCEPTED) {
				sqlStore.updateDelStatus(requestId, newStatus);
			} else {
				DelRequest req = sqlStore.queryDelRequest(requestId);
				sqlStore.deleteThread(req.boardId, req.nid);
				sqlStore.updateDelStatus(requestId, newStatus);
				accCount++;
			}
		}

		out.println("" + reqCount + " requests proceeded.<br>");
		out.println("" + accCount + " requests accepted.<br>");

		sqlStore.close();
	}
}
