/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.task.*;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.model.*;
import com.aibonware.nvrlib.web.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
@SuppressWarnings("serial")
public class SearchServlet extends AuthServlet {
	public static final boolean forceLogin = true;
	public static final boolean allowNextWhenTextSearch = true;
	
	public SearchServlet() {
		super(AUTO_OPEN_NONE);
	}

	protected void dispContents(AuthServletContext ct) throws StoreException, BoardListException, UnsupportedEncodingException  {
		PrintWriter out = ct.out;

		if(forceLogin) {
			if(ct.authUrl.loginMode != 1) {
				out.println("OCĂ܂");
				return;
			}
		}

		SearchUrl url = (SearchUrl)ct.authUrl;
			
		if(url.target == SearchUrl.TARGET_THREAD) {
			dispThreadResult(ct);
		} else if(url.target == SearchUrl.TARGET_ARTICLE) {
			dispArticleResult(ct);
		} else if(url.target == SearchUrl.TARGET_TITLE) {
			dispTitleResult(ct);
		} else {
			dispMain(ct);
		}
	}

	protected AuthServletContext createContext(HttpServletRequest request, HttpServletResponse response, MasterStore store, INaver inaver, PrintWriter out, UserConfig user) throws IOException, StoreException {
		return new AuthServletContext(user, request, response, store, inaver, out, new SearchUrl(request, 0));
	}

	private void dispMain(AuthServletContext ct) throws StoreException {
		PrintWriter out = ct.out;
		SearchUrl searchUrl = (SearchUrl)ct.authUrl;
		BackupStore backup = INaver.getInstance().getStoreProvider().openBackupStore();
		HttpServletResponse response = ct.response;
		
		HttpSession session = ct.request.getSession(false);

		UserConfig user = null;
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		if(user == null) user = new UserConfig();

		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title></title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_INDEX) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toString(response) + "\"></a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_LOGIO) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toLogout(response) + "\">۸ޱ</a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_CONFIG) != 0) {
			out.print("<a href=\"" + searchUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
		}
		
		out.println("<hr>");

        if(!INaver.getInstance().getBackupScheduler().nowStarted) {
            out.println("݌@\͗pł܂B<br>");
            out.println("iүނݽ⼽шُɂ菄@\~Ăꍇɕ\܂j<br>");
        } else {
        	int taskNum = INaver.getInstance().getTaskCount();
        	if(taskNum > 0) out.println("i" + taskNum + "^XN҂j<br><br>");
            out.println("<form action=\"" + ct.authUrl.getLocation(ct.response) + "\" method=\"get\">");
 
            out.println("͈́F<select name=\"r\">");
//            out.println("<option value=\"1\" selected>ŋ");
            out.println("<option value=\"1\" selected>1 Block");
            out.println("<option value=\"2\">2 Block");
            out.println("<option value=\"3\">3 Block");
            out.println("<option value=\"5\">5 Block");
            out.println("<option value=\"10\">10 Block");
            out.println("<option value=\"0\">SO");
            out.println("</select><br>");
    		out.println("<input type=\"radio\" name=\"target\" value=\"article\" checked>ڽ");
    		out.println("<input type=\"radio\" name=\"target\" value=\"thread\">گ");
    		out.println("<input type=\"radio\" name=\"target\" value=\"thread_title\">گ<br>");
    		out.println("F<select name=\"b\">");
    //        out.println("<option value=\"0\">");
    		out.println("ΏہF");

    		BoardList boards = backup.queryBoardList(false, false);

    		for(int i=0; i<boards.getBoardCount(); i++) {
    			Board board = boards.getBoard(i);
    			out.println("<option value=\"" + board.boardId + "\">" + board.dispName);
    		}
    
    		out.println("</select><br>");
    /*		out.println("F<select name=\"country\">");
    		out.println("<option value=\"0\">");
    		out.println("<option value=\"1\">");
    		out.println("<option value=\"2\">");
    		out.println("</select><br>");*/
            out.println("<input type=\"hidden\" name=\"country\" value=\"0\">");
    
            out.println("F<select name=\"e\">");
            out.println("<option value=\"0\">1");
            out.println("<option value=\"2\">3");
            out.println("<option value=\"9\" selected>10");
    		out.println("<option value=\"49\">50");
    		out.println("<option value=\"99\">100");
    		out.println("<option value=\"499\">500");
    		out.println("</select><br>");
    		out.println("eҖF<input type=\"text\" name=\"author\"><br>");
    		out.println("{F<input type=\"text\" name=\"keywords\"><br>");
    
    		out.println("<input type=\"hidden\" name=\"s\" value=\"0\">");
    		
    		if(ct.authUrl.loginMode > 0) {
    			out.println("<input type=\"hidden\" name=\"l\" value=\"1\">");
    		}
    		
    		out.println("<input type=\"submit\" value=\"s\"> ");

			long busyTime = INaver.getInstance().getBackupScheduler().getBusyTime();
			if(busyTime > 10000) out.println(" <font color=\"gray\">(" + (busyTime/1000) + ")</font>");

			out.println("</form>");

			out.println("ڽ̏ꍇ1Block=10Aڌ̏ꍇ1Block=1B<br>");
            out.println("݁Aj[AÕX́uSOvłɃqbg܂B<br>");
        }

        backup.close();
        out.println("</body></html>");
	}

	public void dispArticleResult(AuthServletContext ct) throws BoardListException, StoreException, BoardListException, UnsupportedEncodingException {
		PrintWriter out = ct.out;
		HttpServletRequest request = ct.request;
		HttpServletResponse response = ct.response;
		SearchUrl searchUrl = (SearchUrl)ct.authUrl;

		HttpSession session = request.getSession(false);
		UserConfig user = null;
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		if(user == null) user = new UserConfig();

		String author = searchUrl.author;
		if(author == null) author = "";
//		if(author.length() > 10) author = author.substring(0, 10);
		author = author.trim();

		String keywordsText = searchUrl.keywords;
						
//		System.out.println((int)keywordsText.charAt(0) + ", " + (int)keywordsText.charAt(1));
				
		StringTokenizer tokens = new StringTokenizer(keywordsText, " ");
		
		Vector<String> keywords = new Vector<String>();
		
		while(tokens.hasMoreElements()) {
			keywords.addElement(tokens.nextToken());
		}

		String sBoardId = request.getParameter("b");
		int boardId = AuthUrl.tonum(sBoardId);
        int range = searchUrl.range;
      
        SearchArticleTask task = new SearchArticleTask(user.userName, author, keywords, boardId, searchUrl.country, searchUrl.start, searchUrl.end, range, searchUrl, user);
        INaver.getInstance().getBackupScheduler().addTask(task);

        SearchArticleResult result = task.getResult(user);
        if(task.exception != null) task.exception.printStackTrace(out);
        else if(result == null) {
        	dispSuspendMessage(out, user, searchUrl, response);
            
        	INaver.getInstance().addUserTask(task);
            return;
        }

        result.dispResultContents(out, request, response);
	}
	
	private void dispSuspendMessage(PrintWriter out, UserConfig user, SearchUrl searchUrl, HttpServletResponse response) {
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title></title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");


		if((user.flags & UserConfig.BOARD_HEADER_SHOW_INDEX) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toString(response) + "\"></a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_LOGIO) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toLogout(response) + "\">۸ޱ</a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_CONFIG) != 0) {
			out.print("<a href=\"" + searchUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
		}
		
		if((user.flags & UserConfig.BOARD_HEADER_SHOW_SEARCH) != 0) {
			out.print("<a href=\"" + searchUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
		}

		out.println("<hr>");
       out.println("Ԃѐl(" + Env.getEnv().searchLimitTime + "b)𒴂߁AobNOEh^XNƂēo^܂B<br>");
        out.println("͑słB̏󋵂́Agbvy[WmFł܂B<br>");
        out.println("VXeDB̍ċNsƁA͎܂B<br>");
        out.println("obNOEh^XN̎sʂ́Aʂ{܂ŃVXẽɑޔ܂BVXe̐\򉻂܂̂ŁAԎc邱Ƃ͔ĂB");
        Log.info(user.userName + " search limit over");
		
		out.println("</body></html>");
	}

	public void dispThreadResult(AuthServletContext ct) throws BoardListException, StoreException, BoardListException, UnsupportedEncodingException {
		PrintWriter out = ct.out;
		HttpServletRequest request = ct.request;
		HttpServletResponse response = ct.response;
		SearchUrl searchUrl = (SearchUrl)ct.authUrl;

		HttpSession session = request.getSession(false);
		UserConfig user = null;
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		if(user == null) user = new UserConfig();

		String author = searchUrl.author;
		if(author == null) author = "";
//		if(author.length() > 10) author = author.substring(0, 10);
		author = author.trim();

		String keywordsText = searchUrl.keywords;
				
//		System.out.println((int)keywordsText.charAt(0) + ", " + (int)keywordsText.charAt(1));
				
		StringTokenizer tokens = new StringTokenizer(keywordsText, " ");

		Vector<String> keywords = new Vector<String>();

		while(tokens.hasMoreElements()) {
			keywords.addElement(tokens.nextToken());
		}

		String sBoardId = request.getParameter("b");
		int boardId = AuthUrl.tonum(sBoardId);
        int range = searchUrl.range;
         
        SearchThreadTask task = new SearchThreadTask(author, keywords, boardId, searchUrl.country, searchUrl.start, searchUrl.end, range, searchUrl, user);
        INaver.getInstance().getBackupScheduler().addTask(task);
        
        SearchThreadResult result = task.getResult(user);
        
        if(task.exception != null) task.exception.printStackTrace(out);
        else if(result == null) {
        	dispSuspendMessage(out, user, searchUrl, response);

            INaver.getInstance().addUserTask(task);
            return;
        }

        result.dispResultContents(out, request, response);
 	}

	public void dispTitleResult(AuthServletContext ct) throws BoardListException, StoreException, BoardListException, UnsupportedEncodingException {
		PrintWriter out = ct.out;
		HttpServletRequest request = ct.request;
		HttpServletResponse response = ct.response;
		SearchUrl searchUrl = (SearchUrl)ct.authUrl;

		HttpSession session = request.getSession(false);
		UserConfig user = null;
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		if(user == null) user = new UserConfig();

		String author = searchUrl.author;
		if(author == null) author = "";
//		if(author.length() > 10) author = author.substring(0, 10);
		author = author.trim();

		String keywordsText = searchUrl.keywords;
				
//		System.out.println((int)keywordsText.charAt(0) + ", " + (int)keywordsText.charAt(1));
				
		StringTokenizer tokens = new StringTokenizer(keywordsText, " ");

		Vector<String> keywords = new Vector<String>();

		while(tokens.hasMoreElements()) {
			keywords.addElement(tokens.nextToken());
		}

		String sBoardId = request.getParameter("b");
		int boardId = AuthUrl.tonum(sBoardId);
        int range = searchUrl.range;

        SearchThreadTitleTask task = new SearchThreadTitleTask(author, keywords, boardId, searchUrl.country, searchUrl.start, searchUrl.end, range, searchUrl, user);
        INaver.getInstance().getBackupScheduler().addTask(task);
 
        SearchThreadTitleResult result = task.getResult(user);
        
        if(task.exception != null) task.exception.printStackTrace(out);
        else if(result == null) {
        	dispSuspendMessage(out, user, searchUrl, response);

        	INaver.getInstance().addUserTask(task);
            return;
        }

        result.dispResultContents(out, request, response);
 	}
}
