/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.sql.*;
import java.util.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.model.*;

public class SyncStoreTask extends Task {
  
	private SQLCanceler canceler;
	volatile public boolean canceled = false;
	volatile public Exception exception = null;
	volatile public Vector<ArticleFullPath> articles = null;

    public SyncStoreTask() {
        canceler = new SQLCanceler() {
            private Statement sql;
            
            public void setStatement(Statement sql) {
                this.sql = sql;
            }

            public void cancel() {
                try {
                    sql.cancel();
                } catch(SQLException e) {
                    Log.err("cancel operation failed");
                    Log.err(e);
                }
            }
        };
     }

    public void execute() {
        try {
            if(!canceled) {
    	    	SQLStoreProvider provider = INaver.getInstance().getStoreProvider();
    	    	
    	    	MasterStore master = provider.openMasterStore();
    	    	BackupStore backup = provider.openBackupStore();
    	
    	    	backup.syncStore(master);
    	    	
    	    	master.close();
    	    	backup.close();
            }
        } catch(StoreException e) {
            exception = e;
        }
    }

    public void cancel() {
        canceler.cancel();
        canceled = true;
    }
}
