/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class PageUrl extends AuthUrl {
	public int start;
	public int end;
	public int itemNum;

	protected PageUrl(String location, HttpServletRequest request, int itemNum) {
		super(location, request);
		
		String sStart = request.getParameter("s");
		String sEnd = request.getParameter("e");
	
		this.itemNum = itemNum;
		this.start = tonum(sStart);
		this.end = tonum(sEnd);
	
		if(itemNum < 0) itemNum = end-start;
	
		if(start == -1) start = 0;
		if(start > end) end = start+itemNum-1;
	}
	
	protected PageUrl(String location, int loginMode, int start, int end, int itemNum) {
		super(location, loginMode);
		this.start = start;
		this.end = end;
	}

	public PageUrl(String location, Element root) {
		super(location, root);

		this.start = getIntAttr(root, "Start");
		this.end = getIntAttr(root, "End");
		this.itemNum = getIntAttr(root, "ItemNum");
	}

	public String next(HttpServletResponse response) {
		PageUrl url = (PageUrl)copy();
		url.start = this.end + 1;
		url.end = url.start + itemNum - 1;

		return url.toString(response);
	}
	
	public String prev(HttpServletResponse response) {
		PageUrl url = (PageUrl)copy();
		url.start = this.start - itemNum;
		if(url.start < 0) url.start = 0;
		url.end = this.start - 1;
		if(url.start > url.end) url.end = url.start;
		
		return url.toString(response);
	}
	
	public String changeRange(HttpServletResponse response, int start, int end) {
		PageUrl url = (PageUrl)copy();

		url.start = start;
		url.end = end;
		
		return url.toString(response);
	}

	protected void addParamStrings(Vector<String> params) {
		if(start >= 0) params.addElement("s=" + start);
		if(end >= 0) params.addElement("e=" + end);

		super.addParamStrings(params);
	}
	
	protected void addParamXML(Document doc, Element root) {
		root.appendChild(createAttr(doc, "Start", start));
		root.appendChild(createAttr(doc, "End", end));
		root.appendChild(createAttr(doc, "ItemNum", itemNum));

		super.addParamXML(doc, root);
	}
}
