/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;
import com.aibonware.inaver.model.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class ThreadUrl extends PageUrl {
	public final int boardId;
	public final int nid;
	public final int converterType;
	public int contentMode;

	public ThreadUrl(HttpServletRequest request, int itemNum) {
		super("thread", request, itemNum);

		String sBoardId = request.getParameter("b");
		String sNid = request.getParameter("id");
		String sContentMode = request.getParameter("c");
		String sConverterType = request.getParameter("v");

		this.boardId = tonum(sBoardId);
		this.nid = tonum(sNid);
		this.converterType = tonum(sConverterType);
		this.contentMode = tonum(sContentMode);
	}

	protected ThreadUrl(int loginMode, int start, int end, int boardId, int nid, int itemNum, int contentMode, int converterType) {
		super("thread", loginMode, start, end, itemNum);

		this.boardId = boardId;
		this.nid = nid;
		this.contentMode = contentMode;
		this.converterType = converterType;
	}

	protected void addParamStrings(Vector<String> params) {
		if(boardId > 0) params.addElement("b=" + boardId);
		if(nid > 0) params.addElement("id=" + nid);
		if(converterType > 0) params.addElement("v=" + converterType);
		if(contentMode > 0) params.addElement("c=" + contentMode);

		super.addParamStrings(params);
	}

	public String changeContentMode(HttpServletResponse response, int newContentMode) {
		ThreadUrl url = (ThreadUrl)copy();
		url.contentMode = newContentMode;

		return url.toString(response);
	}

	public String toDontShowAll(HttpServletResponse response) {
		ThreadUrl url = (ThreadUrl)copy();
		url.contentMode = 0;

		return url.toString(response);
	}

	public UpdateUrl getUpdateUrl(UserConfig user, int start, int end, int artNo) {
		return new UpdateUrl(loginMode, boardId, nid, start, end, user.pageArticleNum, artNo);
	}
}
