/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.conv.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class UpdateUrl extends PageUrl {
	public final int boardId;
	public final int nid;
	public final int artNo;

	public UpdateUrl(HttpServletRequest request, int itemNum) {
		super("update", request, itemNum);

		String sBoardId = request.getParameter("b");
		String sNid = request.getParameter("id");
		String sArtNo = request.getParameter("a");

		this.boardId = tonum(sBoardId);
		this.nid = tonum(sNid);
		this.artNo = tonum(sArtNo);
	}

	protected UpdateUrl(int loginMode, int boardId, int nid, int start, int end, int itemNum, int artNo) {
		super("update", loginMode, start, end, itemNum);

		this.boardId = boardId;
		this.nid = nid;
		this.start = start;
		this.end = end;
		this.artNo = artNo;
	}

	protected void addParamStrings(Vector<String> params) {
		if(boardId > 0) params.addElement("b=" + boardId);
		if(nid > 0) params.addElement("id=" + nid);
		if(artNo > 0) params.addElement("a=" + artNo);

		super.addParamStrings(params);
	}

	public ThreadUrl getThreadUrl(UserConfig user) {
		return new ThreadUrl(loginMode, start, end, boardId, nid, user.pageArticleNum, 0, ContentsConverter.CONVERTER_TYPE_DEFAULT);
	}
}
