/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib;

import java.io.*;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;

public class NaverSession {
	private final String userName;
	private final String loginPassword;
	
	private HttpClient client;
	private boolean nowLogin = false;

	public NaverSession(String userName, String loginPassword) {
		this.userName = userName;
		this.loginPassword = loginPassword;

		// ڑݒ
		client = new HttpClient();
		client.setConnectionTimeout(180*1000);
		client.setTimeout(120*1000);
//		client.setStrictMode(true);

		HttpState state = new HttpState();
//		state.setCookiePolicy(CookiePolicy.COMPATIBILITY);
		client.setState(state);
	}

	public void login() throws NetException {
		try {
			// OCp\bh쐬
			PostMethod method = new PostMethod("http://id.enjoykorea.jp/global/join_login_modify_formaction.php");
			method.setFollowRedirects(false);

			// sURL쐬sɂȂ
			method.addParameter("action_mode", "login");
			method.addParameter("url", "about:blank");
			method.addParameter("memberid", userName);
			method.addParameter("password", loginPassword);
			method.addParameter("id_chk", "");

			// s
			int httpStatus = client.executeMethod(method);
			
			if(httpStatus != HttpStatus.SC_MOVED_TEMPORARILY && httpStatus != HttpStatus.SC_OK) {
				throw new NetException("login failed (status code=" + httpStatus + ")");
			}

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "MS932"));
			
			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;

			checkLoginResult(httpStatus, text);
	
			method.releaseConnection();

//			Cookie[] cookies = client.getState().getCookies(); 

/*
			for(int i=0; i<cookies.length; i++) { 
				Cookie c = cookies[i]; 
				String domain = c.getDomain(); 
				if(domain.charAt(0) == '.') continue; 
				c.setDomain("." + domain); 
			} 
*/			
			nowLogin = true;

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		}
	}
	
	private String getAlertString(String text, String startString, String endString) {
		int start = -1;
		int end = -1;
		
		start = text.indexOf(startString);
		if(start >= 0) {
			start += startString.length();
			end = text.indexOf(endString, start);
		}

		if(start < 0 || end < 0) return null;
		else return text.substring(start, end);
	}
	
	private void checkLoginResult(int httpStatus, String text) throws NetException {
		if(httpStatus == HttpStatus.SC_MOVED_TEMPORARILY
		  && text.indexOf("<body><h1>Object Moved</h1>This object may be found <a HREF=\"\">here</a>.</body>") >= 0) {
			return; // no problem
		}
		
		if(httpStatus == HttpStatus.SC_OK
		  && text.indexOf("alert") < 0) {
			return; // no problem
		}
				
		// bZ[W`̂P
		String alert;
		
		alert = getAlertString(text, "alert('", "');");
		if(alert == null) alert = getAlertString(text, "alert( '", "');");
		if(alert == null) alert = getAlertString(text, "alert(\"", "\");");
		if(alert == null) alert = text;

		throw new NetException(alert);
	}

	public void logout() throws NetException {
		try {
			nowLogin = false;

			// OAEgp\bh쐬
			GetMethod method = new GetMethod("http://id.enjoykorea.jp/login/logout.html");
			method.setFollowRedirects(false);
		
			// s
			client.executeMethod(method);
			
			method.releaseConnection();

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		}
	}
	
	public boolean nowLogin() {
		return nowLogin;
	}
	
	public void postArticle(String rawBoardName, int nid, String content) throws NetException {
		try {
			if(nid == 0 || content == null) throw new NetException("sȓeeł");
			
//			Cookie[] cookies = client.getState().getCookies();

			// OCp\bh쐬
			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php");
			method.setFollowRedirects(false);

/*
			for(int i=0; i<cookies.length; i++) {
				Cookie c = cookies[i];
				String domain = c.getDomain();
				if(domain.charAt(0) == '.') continue;
				domain = "." + domain;
				c = new Cookie(domain, c.getName(), c.getValue(), c.getPath(), c.getExpiryDate(), c.getSecure());
				client.getState().addCookie(c);
			}
*/
			method.addParameter("board_id", rawBoardName);
			method.addParameter("nid",  String.valueOf(nid));
			method.addParameter("rtn_url", "about:blank");
			method.addParameter("work", "write");
			method.addParameter("ment_id", "");
			method.addParameter("ment_reply", "");
			method.addParameter("sno", "");
			method.addParameter("ment_passwd", "");
			method.addParameter("ment_writer", userName);
			method.addParameter("ment_passwd_temp", "");
			method.addParameter("ment_ment", content);
	
			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);
/*
			if(httpStatus != HttpStatus.SC_MOVED_TEMPORARILY && httpStatus != HttpStatus.SC_OK) {
				throw new NetException("login failed (status code=" + httpStatus + ")");
			}
*/
			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "MS932"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		}
	}
}

