/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;

/**
 * Xbh\NXB
 * ̃NX̓XꗗێB
 */
public class ArticleList {
	private Vector<Article> articles = new Vector<Article>();
	
	/**
	 * RXgN^B̓eޔB
	 * @param threadUrl ̃XbhURLB
	 */
	public ArticleList() {}

	/**
	 * X̐擾B
	 * @return XB
	 */
	public int getArticleCount() {
		return articles.size();
	}

	/**
	 * XǉB
	 * @param article ǉ郌XB
	 */
	public void addArticle(Article article) {
		articles.addElement(article);
	}
	
	/**
	 * X擾B
	 * @param index 擾郌X̃CfbNXB
	 * @return XB
	 */
	public Article getArticle(int index) {
		return (Article)articles.elementAt(index);
	}

	public void reverse() {
		Vector<Article> revObjects = new Vector<Article>();

		for(int i=articles.size()-1; i>=0; i++) {
			revObjects.addElement(articles.elementAt(i));
		}

		articles = revObjects;
	}
	
	public int getArticleIndexByArticleID(int articleId) {
		int size = articles.size();
		
		for(int i=0; i<size; i++) {
			if(articles.elementAt(i).articleId == articleId) return i;
		}
		
		return -1;
	}
	
	public void removeDenyPoster(HashSet<Poster> denyList) {
		for(int i=0; i<articles.size(); i++) {
			Article art = articles.elementAt(i);
			
			if(denyList.contains(new Poster(art.author, art.country))) {
				articles.removeElementAt(i);
				i--;
			}
		}
	}
}
