/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.text.*;
import java.util.*;

import org.w3c.dom.*;

public class XMLNode {
	public XMLNode() {}

	private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	protected Element createAttr(Document doc, String tagName, int intValue) {
		Element attr;
		attr = doc.createElement(tagName);
		attr.setTextContent(String.valueOf(intValue));
		return attr;
	}
	
	protected Element createAttr(Document doc, String tagName, Date dateValue) {
		Element attr;
		attr = doc.createElement(tagName);
		attr.setTextContent(dateFormat.format(dateValue));
		return attr;
	}
	
	protected Element createAttr(Document doc, String tagName, String strValue) {
		Element attr;
		attr = doc.createElement(tagName);
		attr.setTextContent(strValue);
		return attr;
	}
	
	protected Element createAttr(Document doc, String tagName, boolean boolValue) {
		Element attr;
		attr = doc.createElement(tagName);
		attr.setTextContent(Boolean.toString(boolValue));
		return attr;
	}
	
		
	protected String getStringAttr(Element root, String tagName) {
		String value = root.getElementsByTagName(tagName).item(0).getTextContent();
		return value;
	}

	protected int getIntAttr(Element root, String tagName) {
		String value = root.getElementsByTagName(tagName).item(0).getTextContent();
		return Integer.parseInt(value);
	}

	protected Date getDateAttr(Element root, String tagName) {
		try {
			String value = root.getElementsByTagName(tagName).item(0).getTextContent();
			return dateFormat.parse(value);
		} catch(ParseException e) {
			return null;
		}
	}

	protected boolean getBoolAttr(Element root, String tagName) {
		String value = root.getElementsByTagName(tagName).item(0).getTextContent();
		return Boolean.parseBoolean(value);
	}

}
