/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.table.*;

import org.w3c.dom.*;

import com.aibonware.viewnaver.component.PagePanel;
import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class FavoritePersonConfig extends ConfigItem {
	public Set<Poster> persons = new HashSet<Poster>();
	public String startTag = "<font color=\"green\">";
	public String endTag = "</font>";

	public FavoritePersonConfig() {
		super("FavoritePersonList");
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		persons =  new HashSet<Poster>();
		
		if(elem == null) return;

		startTag = Config.getStringConfig(elem, "StartTag", "<font color=\"green\">");
		endTag = Config.getStringConfig(elem, "EndTag", "</font>");

		NodeList children = elem.getElementsByTagName("FavoritePerson");

		for(int i=0; i<children.getLength(); i++) {
			Element filterElem = (Element)children.item(i);

			Poster poster = Config.getPosterConfig(filterElem, "Poster");

			persons.add(poster);
		}
	}

	@Override public void saveConfig(Element elem) {
		Config.setStringConfig(elem, "StartTag", startTag);
		Config.setStringConfig(elem, "EndTag", endTag);

		NodeList children = elem.getElementsByTagName("FavoritePerson");
		
		for(int i=0; i<children.getLength(); i++) {
			elem.removeChild(children.item(i));
		}

		for(Poster poster: persons) {
			Document doc = elem.getOwnerDocument();
			Element personElem = doc.createElement("FavoritePerson");
			elem.appendChild(personElem);

			Config.setPosterConfig(personElem, "Poster", poster);
		}
	}

	@Override public String getDispPath() {
		return "{.CɓID";
	}

	private static class FavoritePersonConfigView extends ConfigItemView {
		JTable table;
		JTextField startTagField;
		JTextField endTagField;
		JButton deleteButton;
		private FavoritePersonConfig favoritePersonConfig;
		private DefaultTableModel tableModel;

		public FavoritePersonConfigView() {
			tableModel = new DefaultTableModel(new Object[] {"Country", "Poster"}, 0);
			table = new JTable(tableModel);
			
			startTagField = new JTextField();
			endTagField = new JTextField();

			deleteButton = new JButton("폜");

			setAlignmentX(JComponent.LEFT_ALIGNMENT);

			addLine(
				"CɓIDɑ΂ʁF\n",
				glue(new PagePanel(
					"  Jn^O\t", glue(startTagField), "\n",
					"  I^O\t", glue(endTagField))
				), "\n",
				glue(table.getTableHeader()), newline(0),
				glue(table), "\n",
				glue(), deleteButton);

			deleteButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					int row = table.getSelectedRow();
					if(row < 0) return;
					
					tableModel.removeRow(row);
				}
			});
		}

		public void setConfig(ConfigItem config) {
			favoritePersonConfig = (FavoritePersonConfig)config;
			
			for(Poster poster: favoritePersonConfig.persons) {
				tableModel.addRow(new Object[] {poster.country, poster.name});
			}

			startTagField.setText(favoritePersonConfig.startTag);
			endTagField.setText(favoritePersonConfig.endTag);
		}

		public void applyConfig() throws ConfigException {
			favoritePersonConfig.persons.clear();
			
			for(int i=0; i<tableModel.getRowCount(); i++) {
				Country country = (Country)tableModel.getValueAt(i, 0);
				String name = (String)tableModel.getValueAt(i, 1);
				
				favoritePersonConfig.persons.add(new Poster(name, country));
			}

			favoritePersonConfig.startTag = startTagField.getText();
			favoritePersonConfig.endTag = endTagField.getText();
		}
	}

	@Override public ConfigItemView getView() {
		return new FavoritePersonConfigView();
	}
}
