/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.*;

@SuppressWarnings("serial")
public class DenyListContentView extends TabContentView {
	private DenyListContent denyListContent = null;
	private JTable table;

	private Object[] headerNames = new Object[] {"No", "Country", "ID"};
	private int[] headerWidthList = new int[] {40, 30, 90};

	private DefaultTableModel tableModel = new DefaultTableModel(headerNames, 0) {
		@Override public boolean isCellEditable(int row, int column) {
			return false;
		}
	};
	
	private TableColumnModel columnModel;
	
	private JButton updateButton;
	private JButton closeButton;
	private JButton clearDenyListButton;
	
	AbstractAction updateAction = new AbstractAction("XV") {
		public void actionPerformed(ActionEvent e) {
			ViewNaver.instance.mainWindow.containerView.update(denyListContent.getCategory());
		}
	};

	AbstractAction clearDenyListAction = new AbstractAction("ۉ") {
		public void actionPerformed(ActionEvent e) {
			final int[] nidA = getSelectedNidA();
			
			if(nidA.length == 0) {
				ViewNaver.println("IDIĂ܂B");
				return;
			}

			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();

			taskFlow.addStatusReceiver(createTaskStatusReceiver(
					taskFlow,
					clearDenyListButton,
					clearDenyListAction,
					updateButton, closeButton));
			
			taskFlow.execute(new WorkerTask() { 
				public void exec() {
					try {
						ViewNaver.println("Mۂ̉Jn..");
						ViewNaver.instance.naverSession.cancelDenyList(nidA);
						ViewNaver.println("Mۂ̉IB");

						taskFlow.execute(new GUITask() {
							public void exec() {
								ViewNaver.instance.mainWindow.containerView.update(denyListContent.getCategory());
							}
						});

					} catch(NetException e) {
						ViewNaver.err(e);
					}
				}
			});

		}
	};
	
	public TaskStatusReceiver createTaskStatusReceiver(
			final TaskFlow taskFlow, 
			final JButton cabcelableButton, 
			final AbstractAction originalAction,
			final JButton... otherButtons) {
		return new TaskStatusReceiver() {
			public void statusChanged(int status) {
				if(status == RUNNING) {
					cabcelableButton.setAction(new AbstractAction("~") {
						public void actionPerformed(ActionEvent e) {
							taskFlow.cancel();
						}
					});

					for(JButton otherButton: otherButtons) {
						otherButton.setEnabled(false);
					}
					
				}  else if(status == FINISHED) {
					cabcelableButton.setAction(originalAction);

					for(JButton otherButton: otherButtons) {
						otherButton.setEnabled(true);
					}
				}
			}
		};
	}

	public TaskStatusReceiver createUpdateTaskStatusReceiver(TaskFlow taskFlow) {
		return createTaskStatusReceiver(taskFlow, updateButton, updateAction, closeButton, clearDenyListButton);
	}
	
	public DenyListContentView(TabContentCategory category) {
		super(category);

		table = new JTable(tableModel);
		
		columnModel = table.getColumnModel();

		for(int i=0; i<headerWidthList.length; i++) {
			columnModel.getColumn(i).setPreferredWidth(headerWidthList[i]);
		}

		final JToolBar toolbar = new JToolBar();

		updateButton = new JButton();
		closeButton = new JButton("");
		clearDenyListButton = new JButton("ۉ");
		
		toolbar.add(updateButton);
		toolbar.add(closeButton);
		toolbar.addSeparator();
		toolbar.add(clearDenyListButton);
		
		toolbar.setFloatable(false);

		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ViewNaver.instance.mainWindow.container.removeContent(denyListContent);
			}
		});

		updateButton.setAction(updateAction);
		clearDenyListButton.setAction(clearDenyListAction);

		add(toolbar, BorderLayout.NORTH);
		add(new JScrollPane(table), BorderLayout.CENTER);
	}

	public void setClientContent(TabContent content) {
		denyListContent = (DenyListContent)content;
		
		tableModel.setRowCount(0);
		
		for(int i=0; i<denyListContent.denyList.size(); i++) {
			DenyEntry deny = denyListContent.denyList.elementAt(i);
			
			tableModel.addRow(new Object[] {deny.nidA, deny.country, deny.receiver});
		}
	}
	
	public int[] getSelectedNidA() {
		int[] rows = table.getSelectedRows();
		
		int[] nidA = new int[rows.length];
		
		for(int i=0; i<rows.length; i++) {
			nidA[i] = denyListContent.denyList.elementAt(i).nidA;
		}
		
		return nidA;
	}
}

