/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import java.util.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.window.*;
import com.aibonware.viewnaver.storage.*;
import com.aibonware.viewnaver.task.*;

@SuppressWarnings("serial")
public class ReceivedMessageContentView extends MessageContentView {
	private JButton replyButton;
	private JButton denyButton;

	public ReceivedMessageContentView(TabContentCategory category) {
		super(category, "http://bbs.enjoykorea.jp/memo/memo_view.php?no=", new MessageListView.MessageAdapter() {
			public void saveMessage(Message message) {
				try {
					ViewNaver.instance.messageStorage.saveReceivedMessage(
							ViewNaver.instance.naverSession.getUserName(),
							message);
				} catch(StorageException e) {
					ViewNaver.err(e);
				}
			}
			
			public Message getMessage(int messageId) {
				return ViewNaver.instance.messageStorage.getReceivedMessage(messageId);
			}
		});

		replyButton = new JButton("ԐM");
		denyButton = new JButton("M");

		replyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				final MessageTitle message = messageListView.getSelectedMessage();
				if(message == null) return;

				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageFlow(message.messageId);

				taskFlow.execute(new WorkerTask() { 
					public void exec() {
						try {
							ViewNaver.println("ԐMbZ[W̓ǂݍ݊Jn..");
							final String replyText = getReplyMessageText(message);
							ViewNaver.println("ԐMbZ[W̓ǂݍݏIB");

							taskFlow.execute(new GUITask() {
								public void exec() {
									WriteMessageWindow replyWindow = new WriteMessageWindow(
											ViewNaver.instance.mainWindow,
											message.person,
											message.country,
											replyText);
									
									replyWindow.setVisible(true);
								}
							});
						} catch(NetException e) {
							ViewNaver.err(e);
						} catch(ParsingException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});
		
		denyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				final MessageTitle[] messageList = messageListView.getSelectedMessageList();

				if(messageList.length == 0) {
					ViewNaver.println("bZ[WIĂ܂B");
					return;
				}
				
				final HashSet<Poster> senders = new HashSet<Poster>();
				
				for(int i=0; i<messageList.length; i++) {
					Poster sender = new Poster(messageList[i].person, messageList[i].country);
					if(!senders.contains(sender)) senders.add(sender);
				}
				
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();

				taskFlow.execute(new WorkerTask() { 
					public void exec() {
						try {
							for(Poster sender: senders) {
								ViewNaver.println(sender.name + "̎MۊJn..");
									ViewNaver.instance.naverSession.denyMessage(sender.name, sender.country);
								}
	
								ViewNaver.println("MۏIB");
/*	
							ViewNaver.runGUI(new Runnable() {
								public void run() {
									ViewNaver.instance.mainWindow.containerView.update(DenyListView.getCategory());
								}
							});
*/						} catch(NetException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});
		
		toolbar.addSeparator();
		toolbar.add(replyButton);
		toolbar.add(denyButton);

		add(toolbar, BorderLayout.NORTH);
	}

	protected void saveServerMessage(int[] messageIdList) throws NetException {
		ViewNaver.instance.naverSession.saveReceivedMessage(messageIdList);
	}
	
	protected void deleteServerMessage(int[] messageIdList) throws NetException {
		ViewNaver.instance.naverSession.deleteReceivedMessage(messageIdList);
	}
}
