/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.storage.*;

@SuppressWarnings("serial")
public class SentMessageContentView extends MessageContentView {
	public SentMessageContentView(TabContentCategory category) {
		super(category, "http://bbs.enjoykorea.jp/memo/save_view.php?no=", new MessageListView.MessageAdapter() {
			public void saveMessage(Message message) {
				try {
					ViewNaver.instance.messageStorage.saveSentMessage(
							ViewNaver.instance.naverSession.getUserName(),
							message);
				} catch(StorageException e) {
					ViewNaver.err(e);
				}
			}

			public Message getMessage(int messageId) {
				return ViewNaver.instance.messageStorage.getSentMessage(messageId);
			}
		});
	}

	protected void saveServerMessage(int[] messageIdList) throws NetException {
		ViewNaver.instance.naverSession.saveSentMessage(messageIdList);
	}
	
	protected void deleteServerMessage(int[] messageIdList) throws NetException {
		ViewNaver.instance.naverSession.deleteSentMessage(messageIdList);
	}
}
