/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

import java.util.*;

/**
 * Xbh\NXB
 * ̃NX̓XꗗێB
 */
public class ArticleList {
	private Vector<Article> articles = new Vector<Article>();
	
	/**
	 * RXgN^B̓eޔB
	 * @param threadUrl ̃XbhURLB
	 */
	public ArticleList() {}

	/**
	 * X̐擾B
	 * @return XB
	 */
	public int getArticleCount() {
		return articles.size();
	}

	/**
	 * XǉB
	 * @param article ǉ郌XB
	 */
	public void addArticle(Article article) {
		articles.addElement(article);
	}
	
	/**
	 * X擾B
	 * @param index 擾郌X̃CfbNXB
	 * @return XB
	 */
	public Article getArticle(int index) {
		return (Article)articles.elementAt(index);
	}
	
	public void removeArticle(int index) {
		articles.removeElementAt(index);
	}

	public void reverse() {
		Vector<Article> revObjects = new Vector<Article>();

		for(int i=articles.size()-1; i>=0; i++) {
			revObjects.addElement(articles.elementAt(i));
		}

		articles = revObjects;
	}
	
	public int getArticleIndexByArticleID(int articleId) {
		int size = articles.size();
		
		for(int i=0; i<size; i++) {
			if(articles.elementAt(i).articleId == articleId) return i;
		}

		return -1;
	}

	public Article getArticleByArticleID(int articleId) {
		int size = articles.size();
		
		for(int i=0; i<size; i++) {
			if(articles.elementAt(i).articleId == articleId) return articles.elementAt(i);
		}

		return null;
	}
	
	public List<Article> subList(int start, int end) {
		return articles.subList(start, end);
	}
	
	public void sort() {
		Collections.sort(articles, new Comparator<Article>() {
			public int compare(Article src, Article dest) {
				if(src.sno != dest.sno) return src.sno - dest.sno;
				return src.articleId - dest.articleId;
			}
		});
	}

	public void merge(ArticleList newArticles) {
		for(int i=0; i<getArticleCount(); i++) {
			Article art = getArticle(i);

			art.prevIsNew = art.isNew;
			art.isNew = false;
			if(newArticles.getArticleByArticleID(art.articleId) == null) art.isDeleted = true;
		}

		for(int i=0; i<newArticles.getArticleCount(); i++) {
			Article art = newArticles.getArticle(i);
			if(this.getArticleByArticleID(art.articleId) == null) articles.addElement(art);
		}

		sort();
	}

/*
	public void sortReplyArticle() {
		int start = 0;
		int end = 0;

		for(;;) {
			// ݈ʒuȍ~ōŏ̕ԐMXTB
			start = findStartReply(start);
			if(start == -1) return;

			// ݂̕ԐMXO[v̖TB
			end = findEndReply(start);

			if(end - start > 1) sortPartReply(start, end);

			start = end + 1;
		}
	}

	private int findStartReply(int start) {
		for(int i=start; i<getArticleCount(); i++) {
			if(getArticle(i).isReply) return i;
		}

		return -1;
	}

	private int findEndReply(int start) {
		for(int i=start+1; i<getArticleCount(); i++) {
			if(!getArticle(i).isReply) return i-1;
		}
		
		return getArticleCount()-1;
	}

	private void sortPartReply(int start, int end) {
		Collections.sort(subList(start, end), new Comparator<Article>() {
			public int compare(Article src, Article dest) {
				return src.articleId - dest.articleId;
			}
		});
	}

	public void doOld() {
		for(int i=0; i<articles.size(); i++) {
			articles.elementAt(i).isNew = false;
		}
	}

	public void setParentId() {
		int currentParentId = -1;
		
		for(int i=0; i<articles.size(); i++) {
			Article art = articles.elementAt(i);
			
			if(art.isReply) art.parentArticleId = currentParentId;
			else currentParentId = art.articleId;
		}
	}
	

	public void clearParentId() {
		for(int i=0; i<articles.size(); i++) {
			articles.elementAt(i).parentArticleId = -1;
		}
	}

	public void update(Vector<ArticleDiff> diffs) {
		for(int i=0; i<diffs.size(); i++) {
			ArticleDiff diff = diffs.elementAt(i);
			int prevIndex = getArticleIndexByArticleID(diff.prevArticleId);
			articles.insertElementAt(diff.article, prevIndex+1);
		}
	}
	
	public Vector<ArticleDiff> diff(ArticleList newArticles) {
		setParentId();
		doOld();
		newArticles.clearParentId();

		int currentParentId = -1;

		for(int i=0; i<newArticles.getArticleCount(); i++) {
			Article newArt = newArticles.getArticle(i);
			if(!newArt.isReply) currentParentId = newArt.articleId;

			Article art = this.getArticleByArticleID(newArt.articleId);

			if(art != null) {
				currentParentId = art.parentArticleId;
				newArt.isNew = false;
			}

			if(newArt.isReply) newArt.parentArticleId = currentParentId;
		}

		Vector<ArticleDiff> diffs = new Vector<ArticleDiff>();
		
		Article lastArt;
		
		if(articles.isEmpty()) lastArt = null;
		else lastArt = articles.lastElement();
		
		for(int i=0; i<newArticles.getArticleCount(); i++) {
			Article newArt = newArticles.getArticle(i);

			if(!newArt.isNew) continue;

			if(lastArt == null) {
				diffs.addElement(new ArticleDiff(-1, newArt));
				lastArt = newArt;
				continue;
			}

			if(!newArt.isReply) {
				diffs.addElement(new ArticleDiff(lastArt.articleId, newArt));
				lastArt = newArt;
			} else {
				if(newArt.parentArticleId == -1) {
					diffs.addElement(new ArticleDiff(lastArt.articleId, newArt));
					lastArt = newArt;
				} else {
					int index = this.getArticleIndexByArticleID(newArt.parentArticleId);
					int endReply = findEndReply(index);

					if(endReply >= 0) {
						diffs.add(new ArticleDiff(articles.elementAt(index).articleId, newArt));

						if(articles.elementAt(index) == lastArt) {
							lastArt = newArt;
						}
					} else {
						diffs.addElement(new ArticleDiff(lastArt.articleId, newArt));
						lastArt = newArt;
					}
				}
			}
		}

		return diffs;
		

	}

	private void removeOldReply(Vector<ArticleGroup> groups) {
		for(int i=0; i<groups.size(); i++) {
			ArticleGroup group = groups.elementAt(i);

			for(int j=0; j<group.getArticleCount(); j++) {
				if(!group.getArticle(j).isNew) {
					group.removeArticle(j);
					j--;
				}
			}
			
			if(group.getArticleCount() == 0) {
				groups.removeElementAt(i);
				i--;
			}
		}
	}
	
	private Vector<ArticleGroup> getArticleGroups() {
		Vector<ArticleGroup> groups = new Vector<ArticleGroup>();
		ArticleGroup currentGroup = new ArticleGroup();

		for(int i=0; i<articles.size(); i++) {
			Article art = articles.elementAt(i);

			if(!art.isReply) {
				if(!currentGroup.isEmpty()) {
					groups.add(currentGroup);
				}

				currentGroup = new ArticleGroup();
				currentGroup.parentArticleId = art.parentArticleId;
			} else {
				if(art.parentArticleId == currentGroup.parentArticleId) { 
					currentGroup.addArticle(art);
				} else {
					if(!currentGroup.isEmpty()) {
						groups.add(currentGroup);
					}

					currentGroup = new ArticleGroup();
					currentGroup.parentArticleId = art.parentArticleId;
				}
			}
		}

		return groups;
	}
*/
}
