/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

import java.util.*;

public class MessageTitleList {
	public final int receivedNum;
	public final int preReceivedNum;
	public final int sendNum;
	
	private Vector< MessageTitle> messages = new Vector<MessageTitle>();

	public MessageTitleList(int receivedNum, int preReceivedNum, int sendNum) {
		this.receivedNum = receivedNum;
		this.preReceivedNum = preReceivedNum;
		this.sendNum = sendNum;
	}

	public void addMessageTitle(MessageTitle message) {
		messages.addElement(message);
	}

	public int getMessageCount() {
		return messages.size();
	}

	public MessageTitle getMessageTitle(int index) {
		return (MessageTitle)messages.elementAt(index);
	}

	public MessageTitle getMessageTitleByMessageId(int messageId) {
		for(int i=0; i<messages.size(); i++) {
			MessageTitle title = messages.elementAt(i);
			if(title.messageId == messageId) return title;
		}
		
		return null;
	}
	
	public void replace(MessageTitle oldTitle, MessageTitle newTitle) {
		messages.setElementAt(newTitle, messages.indexOf(oldTitle));
	}
	
	public void sort() {
		Collections.sort(messages, new Comparator<MessageTitle>() {
			public int compare(MessageTitle src, MessageTitle dest) {
				return dest.messageId - src.messageId;
			}
		});
	}
	
	public void merge(MessageTitleList newTitles) {
		for(int i=0; i<newTitles.getMessageCount(); i++) {
			MessageTitle newTitle = newTitles.getMessageTitle(i);
			MessageTitle oldTitle = getMessageTitleByMessageId(newTitle.messageId);
			
			if(oldTitle != null) replace(oldTitle, newTitle);
			else addMessageTitle(newTitle);
		}
	}
}
