/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;

public class ReplyMessageParser {
	String urlString;
	
	public ReplyMessageParser(String urlString) {
		this.urlString = urlString;
	}
	
	public String parse() throws NetException, ParsingException {
		BufferedReader reader = ViewNaver.instance.naverSession.open(urlString, "UTF8");

		String result = parse(reader);

		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}

	public String parse(BufferedReader reader) throws ParsingException, NetException  {
		ParsingContext ct = new ParsingContext(reader);

		try {
			ct.seek("textarea name=\"content\"");
			String text = ct.cut(">", "</textarea>");
			
			return text;
			
		} catch(NumberFormatException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}
}
