/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;

import java.io.*;
import java.util.*;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.server.*;

public abstract class BaseServlet extends HttpServlet {
	public static volatile boolean mustReject = false;
	
	public BaseServlet() {}

	public abstract String getName();
	
	protected boolean isText() {
		return true;
	}
	
	@Override public final void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
		MiniServer server = ViewNaver.instance.server;
		boolean isText = isText();

		if(isText) {
			response.setStatus(HttpServletResponse.SC_OK);
			response.setContentType("text/html; charset=Shift_JIS");
		}

		ServletOutputStream out = response.getOutputStream();

		if(mustReject) {
			if(isText) out.println("OANZXً͋}Ւf܂B");
			out.flush();
			out.close();
			return;
		}

		String sid = request.getParameter("sid");

		try {
			if(isText) out.println("<html><head><title>" + getName() + "</title></head><body>");

			if(!getName().equals("login") && !server.isValidSid(sid)) {
				if(isText) dispLogin(server, request, response, out);
			} else {
				UserSession user = server.getSession(sid);
				
				if(user != null && user.warning != null) if(isText) out.println(user.warning + "<br>");
				
				if(user != null) {
					Vector<String> messages = user.clearOnceMessages();
					for(String msg: messages) out.println(msg);
				}

				dispContents(server, user, request, response, out);
			}
		} catch(Exception e) {
			if(isText) out.println(e.getMessage());
			ViewNaver.err(e);
		}

		if(isText) out.println("</body></html>");
		
		out.flush();
		out.close();
	}

	public void dispLogin(MiniServer server, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception { 
		String sid = server.createSid();

		out.println("<form method=\"post\" action=\"login\">");
		out.println("<input type=\"hidden\" name=\"sid\" value=\"" + sid + "\">");
		out.println("<input type=\"password\" name=\"pwd\">");
		out.println("<input type=\"submit\" value=\"OK\">");
		out.println("</form>");
	}
	
	public abstract void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception;

	protected String getPostContent(HttpServletRequest request) throws IOException {
		InputStream reqIn = request.getInputStream();
		int contentLength = request.getContentLength();

		if(contentLength == -1) return "";
		
		byte[] content = new byte[contentLength];
		
		for (int i = 0; i < contentLength; ++i) {
			int c = reqIn.read();
			if (c == -1) break;

			content[i] = (byte)c;
		}
		
		return new String(content, "Shift_JIS");
	}
	
	protected TreeMap<String /*name*/, String /*value*/> getPostParams(HttpServletRequest request) throws IOException {
		String content = getPostContent(request);
		
		StringTokenizer pairs = new StringTokenizer(content, "&");
		TreeMap<String, String> params = new TreeMap<String, String>();
		
		while(pairs.hasMoreTokens()) {
			String pair = pairs.nextToken();
			
			int equalPos = pair.indexOf("=");
			
			if(equalPos == -1) throw new IOException("invalid post request");
			
			params.put(
					pair.substring(0, equalPos),
					pair.substring(equalPos+1));
		}
		
		return params;
	}
}
