package com.aibonware.viewnaver.task;

import java.awt.event.*;

import javax.swing.*;

@SuppressWarnings("serial")
public class DefaultTaskStatusReceiver extends TaskStatusReceiver {
	final TaskFlow taskFlow;
	final JButton cabcelableButton;
	final AbstractAction originalAction;
	final JButton[] otherButtons;
	
	public DefaultTaskStatusReceiver(
			TaskFlow taskFlow, 
			JButton cabcelableButton, 
			AbstractAction originalAction,
			JButton... otherButtons) {
		this.taskFlow = taskFlow;
		this.cabcelableButton = cabcelableButton;
		this.originalAction = originalAction;
		this.otherButtons = otherButtons;
	}

	public void statusChanged(int status) {
		if(status == RUNNING) {
			cabcelableButton.setAction(new AbstractAction("~") {
				public void actionPerformed(ActionEvent e) {
					taskFlow.cancel();
				}
			});

			for(JButton otherButton: otherButtons) {
				if(otherButton != cabcelableButton) otherButton.setEnabled(false);
			}
			
		}  else if(status == FINISHED) {
			cabcelableButton.setAction(originalAction);

			for(JButton otherButton: otherButtons) {
				if(otherButton != cabcelableButton) otherButton.setEnabled(true);
			}
		}
	}
}
