/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.awt.*;

import javax.swing.*;
import com.aibonware.viewnaver.component.*;

@SuppressWarnings("serial")
public class SearchLocalThreadView extends PagePanel {
	JTextField posterText;
	JTextField keywordText;
//	JCheckBox unicodeCheck;

	JEnumRadioButton<LocalSearchType> searchThreadTitleRadio;
	JEnumRadioButton<LocalSearchType> searchThreadContentRadio;
	JEnumRadioButton<LocalSearchType> searchArticleRadio;
	
	ButtonGroup group = new ButtonGroup();

	public SearchLocalThreadView(String keyword, LocalSearchType localSearchType) {

		searchThreadTitleRadio = new JEnumRadioButton<LocalSearchType>("Xbh^Cg", LocalSearchType.SearchThreadTitle);
		searchThreadContentRadio = new JEnumRadioButton<LocalSearchType>("Xbhe", LocalSearchType.SearchThreadContent);
		searchArticleRadio = new JEnumRadioButton<LocalSearchType>("X", LocalSearchType.SearchArticle);

		posterText = new JTextField();
		posterText.setMaximumSize(new Dimension(1000, 20));

		keywordText = new JTextField();
		keywordText.setMaximumSize(new Dimension(1000, 20));
		
		group.add(searchThreadTitleRadio);
		group.add(searchThreadContentRadio);
		group.add(searchArticleRadio);

		searchThreadTitleRadio.setSelected(true);
		
		if(localSearchType != null) {
			if(localSearchType.equals(LocalSearchType.SearchThreadTitle)) searchThreadTitleRadio.setSelected(true);
			if(localSearchType.equals(LocalSearchType.SearchThreadContent)) searchThreadContentRadio.setSelected(true);
			if(localSearchType.equals(LocalSearchType.SearchArticle)) searchArticleRadio.setSelected(true);
		}

		if(keyword != null) keywordText.setText(keyword);

		addLine("@F\n",
				" ", searchThreadTitleRadio, "\n",
				" ", searchThreadContentRadio, "\n", 
				" ", searchArticleRadio, "\n",
				glue(new PagePanel() {{
					addLine("eҖF\t", glue(posterText), "\n",
							"L[[hF\t", glue(keywordText));
				}}), "\n",
				"ӁF̎ł́AUNICODEꂽe^Oɂ\n",
				"@PȕvŃ}b`Ȃ͌ł܂B\n",
				"@܂AL[[h͋󗓂܂͒P̂ݓ͂ĂB");
	}

	public LocalSearchType getLocalSearchType() {
		return ((EnumButtonModel<LocalSearchType>)group.getSelection()).enumValue;
	}
	
	public String getPoster() {
		String text = posterText.getText();
		if(text.trim().equals("")) return null;
		else return text;
	}
	
	public String getKeyword() {
		String text = keywordText.getText();
		if(text.trim().equals("")) return null;
		else return text;
	}
}
