/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.net;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.net.NotLoginException;
import com.aibonware.nvrlib.task.TaskCanceller;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class AnonymousSession
implements NaverSession {
    public final String userName;
    protected HttpClient client;
    protected final HttpCancellerProvider canellerProvider;

    public AnonymousSession(String userName, String proxyHost, int proxyPort, HttpCancellerProvider canellerProvider) {
        this.userName = userName;
        this.canellerProvider = canellerProvider;
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        this.client = new HttpClient((HttpConnectionManager)connectionManager);
        connectionManager.getParams().setConnectionTimeout(180000);
        connectionManager.getParams().setSoTimeout(120000);
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(5);
        connectionManager.getParams().setMaxTotalConnections(5);
        HttpState state = new HttpState();
        this.client.setState(state);
        if (proxyHost != null) {
            this.client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
    }

    @Override
    public BufferedReader open(String url) throws NetException {
        return this.open(url, false);
    }

    public BufferedReader open(String url, boolean followRedirects) throws NetException {
        TaskCanceller canceller = null;
        try {
            final GetMethod method = new GetMethod(url);
            canceller = this.canellerProvider.createCanceller((HttpMethod)method);
            method.setFollowRedirects(followRedirects);
            this.client.executeMethod((HttpMethod)method);
            final TaskCanceller fcanceller = canceller;
            return new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8")){

                @Override
                public void close() throws IOException {
                    AnonymousSession.this.canellerProvider.disposeCanceller(fcanceller);
                    method.releaseConnection();
                }
            };
        }
        catch (HttpException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
        catch (IOException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
    }

    public ImageBinary getImageBinary(String url) throws NetException {
        try {
            GetMethod method = new GetMethod(url);
            method.setFollowRedirects(false);
            this.client.executeMethod((HttpMethod)method);
            ImageBinary image = new ImageBinary(method.getResponseHeader("Content-Type").getValue(), method.getResponseBody());
            method.releaseConnection();
            return image;
        }
        catch (HttpException e) {
            throw new NetException(e);
        }
        catch (IOException e) {
            throw new NetException(e);
        }
    }

    @Override
    public InputStream openStream(String url) throws NetException {
        return this.openStream(url, false);
    }

    public InputStream openStream(String url, boolean followRedirects) throws NetException {
        TaskCanceller canceller = null;
        try {
            final GetMethod method = new GetMethod(url);
            canceller = this.canellerProvider.createCanceller((HttpMethod)method);
            method.setFollowRedirects(followRedirects);
            this.client.executeMethod((HttpMethod)method);
            final TaskCanceller fcanceller = canceller;
            return new FilterInputStream(method.getResponseBodyAsStream()){

                @Override
                public void close() throws IOException {
                    AnonymousSession.this.canellerProvider.disposeCanceller(fcanceller);
                    method.releaseConnection();
                }
            };
        }
        catch (HttpException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
        catch (IOException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
    }

    @Override
    public BufferedReader open(String url, String encoding) throws NetException {
        TaskCanceller canceller = null;
        try {
            final GetMethod method = new GetMethod(url);
            canceller = this.canellerProvider.createCanceller((HttpMethod)method);
            method.setFollowRedirects(false);
            this.client.executeMethod((HttpMethod)method);
            final TaskCanceller fcanceller = canceller;
            return new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), encoding)){

                @Override
                public void close() throws IOException {
                    AnonymousSession.this.canellerProvider.disposeCanceller(fcanceller);
                    method.releaseConnection();
                }
            };
        }
        catch (HttpException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
        catch (IOException e) {
            this.canellerProvider.disposeCanceller(canceller);
            throw new NetException(e);
        }
    }

    private static String getAlertString(String text, String startString, String endString) {
        int start = -1;
        int end = -1;
        start = text.indexOf(startString);
        if (start >= 0) {
            end = text.indexOf(endString, start += startString.length());
        }
        if (start < 0 || end < 0) {
            return null;
        }
        return text.substring(start, end);
    }

    public static String getAlertString(String text) {
        String alert = AnonymousSession.getAlertString(text, "alert('", "');");
        if (alert == null) {
            alert = AnonymousSession.getAlertString(text, "alert( '", "');");
        }
        if (alert == null) {
            alert = AnonymousSession.getAlertString(text, "alert(\"", "\");");
        }
        if (alert == null) {
            alert = AnonymousSession.getAlertString(text, "alert ('", "');");
        }
        if (alert == null) {
            alert = AnonymousSession.getAlertString(text, "alert ( '", "');");
        }
        if (alert == null) {
            alert = AnonymousSession.getAlertString(text, "alert (\"", "\");");
        }
        if (alert == null) {
            alert = text;
        }
        return alert.replace("\\n", "\n");
    }

    @Override
    public void login(String loginPassword) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void logout() throws NetException {
        throw new NotLoginException();
    }

    @Override
    public boolean nowLogin() {
        return false;
    }

    @Override
    public void postArticle(String rawBoardName, int nid, String htmlContent) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void replyArticle(String rawBoardName, int nid, String htmlContent, int sno) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void deleteArticle(String rawBoardName, int nid, int articleId) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public int postThread(String boardName, String title, String content) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void replyThread(String boardName, String title, String content, int nid, int sno) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void modifyThread(String boardName, String title, String content, int nid) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void deleteThread(String boardName, int nid) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void sendMessage(String receiver, Country country, String messageText, boolean saveServer) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void saveReceivedMessage(int[] messageIdList) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void saveSentMessage(int[] messageIdList) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void deleteReceivedMessage(int[] messageIdList) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void deleteSentMessage(int[] messageIdList) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void denyMessage(String sender, Country country) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public void cancelDenyList(int[] nidA) throws NetException {
        throw new NotLoginException();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public Country getCountry() {
        return Country.JAPAN;
    }

    public static class ImageBinary {
        public final String contentType;
        public final byte[] bin;

        public ImageBinary(String contentType, byte[] bin) {
            this.contentType = contentType;
            this.bin = bin;
        }
    }
}

